package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取小代码数据参数
 */
@ApiModel(description = "获取小代码数据参数")

@JsonInclude(NON_NULL)
public class MsConfigGetSysCodeRequest {
  @JsonProperty("sysId")
  private String sysId = null;

  @JsonProperty("sysCode")
  private String sysCode = null;

  @JsonIgnore
  public MsConfigGetSysCodeRequest sysId(String sysId) {
    this.sysId = sysId;
    return this;
  }

   /**
   * 代码ID
   * @return sysId
  **/
  @ApiModelProperty(value = "代码ID")
  public String getSysId() {
    return sysId;
  }

  public void setSysId(String sysId) {
    this.sysId = sysId;
  }

  @JsonIgnore
  public MsConfigGetSysCodeRequest sysCode(String sysCode) {
    this.sysCode = sysCode;
    return this;
  }

   /**
   * 代码CODE
   * @return sysCode
  **/
  @ApiModelProperty(value = "代码CODE")
  public String getSysCode() {
    return sysCode;
  }

  public void setSysCode(String sysCode) {
    this.sysCode = sysCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigGetSysCodeRequest configGetSysCodeRequest = (MsConfigGetSysCodeRequest) o;
    return Objects.equals(this.sysId, configGetSysCodeRequest.sysId) &&
        Objects.equals(this.sysCode, configGetSysCodeRequest.sysCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sysId, sysCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigGetSysCodeRequest {\n");
    
    sb.append("    sysId: ").append(toIndentedString(sysId)).append("\n");
    sb.append("    sysCode: ").append(toIndentedString(sysCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
