package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 生成购方小代码配置参数
 */
@ApiModel(description = "生成购方小代码配置参数")

@JsonInclude(NON_NULL)
public class MsCreatePurchaserSyscodeRequest {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("packageCodes")
  private List<String> packageCodes = new ArrayList<String>();

  @JsonIgnore
  public MsCreatePurchaserSyscodeRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/
  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsCreatePurchaserSyscodeRequest packageCodes(List<String> packageCodes) {
    this.packageCodes = packageCodes;
    return this;
  }

  public MsCreatePurchaserSyscodeRequest addPackageCodesItem(String packageCodesItem) {
    this.packageCodes.add(packageCodesItem);
    return this;
  }

   /**
   * 计费服务包代码数组
   * @return packageCodes
  **/
  @ApiModelProperty(value = "计费服务包代码数组")
  public List<String> getPackageCodes() {
    return packageCodes;
  }

  public void setPackageCodes(List<String> packageCodes) {
    this.packageCodes = packageCodes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCreatePurchaserSyscodeRequest createPurchaserSyscodeRequest = (MsCreatePurchaserSyscodeRequest) o;
    return Objects.equals(this.tenantCode, createPurchaserSyscodeRequest.tenantCode) &&
        Objects.equals(this.packageCodes, createPurchaserSyscodeRequest.packageCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, packageCodes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCreatePurchaserSyscodeRequest {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    packageCodes: ").append(toIndentedString(packageCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
