package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCrmAuditFileUrlBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 保利供应商主信息同步请求
 */
@ApiModel(description = "保利供应商主信息同步请求")

@JsonInclude(NON_NULL)
public class MsCrmPolyCmpInfoSyncRequest {
  @JsonProperty("applySerialNo")
  private String applySerialNo = null;

  @JsonProperty("applyBatchNo")
  private String applyBatchNo = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("companyNo")
  private String companyNo = null;

  @JsonProperty("companyType")
  private String companyType = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyAddr")
  private String companyAddr = null;

  @JsonProperty("companyTel")
  private String companyTel = null;

  @JsonProperty("taxpayerType")
  private String taxpayerType = null;

  @JsonProperty("contactorName")
  private String contactorName = null;

  @JsonProperty("contactorEmail")
  private String contactorEmail = null;

  @JsonProperty("contactorPhone")
  private String contactorPhone = null;

  @JsonProperty("contactorTel")
  private String contactorTel = null;

  @JsonProperty("companyBankName")
  private String companyBankName = null;

  @JsonProperty("companyBankAccount")
  private String companyBankAccount = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceLimitAmountC")
  private String invoiceLimitAmountC = null;

  @JsonProperty("invoiceLimitAmountS")
  private String invoiceLimitAmountS = null;

  @JsonProperty("taxDiskType")
  private String taxDiskType = null;

  @JsonProperty("invoiceMaker")
  private String invoiceMaker = null;

  @JsonProperty("invoiceEmail")
  private String invoiceEmail = null;

  @JsonProperty("applyUserName")
  private String applyUserName = null;

  @JsonProperty("applyUserEmail")
  private String applyUserEmail = null;

  @JsonProperty("applyUserPhone")
  private String applyUserPhone = null;

  @JsonProperty("isCreateUser")
  private String isCreateUser = null;

  @JsonProperty("auditFileUrl")
  private MsCrmAuditFileUrlBean auditFileUrl = null;

  @JsonProperty("clickFlag")
  private Boolean clickFlag = null;

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest applySerialNo(String applySerialNo) {
    this.applySerialNo = applySerialNo;
    return this;
  }

   /**
   * 申请流水号
   * @return applySerialNo
  **/
  @ApiModelProperty(value = "申请流水号")
  public String getApplySerialNo() {
    return applySerialNo;
  }

  public void setApplySerialNo(String applySerialNo) {
    this.applySerialNo = applySerialNo;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest applyBatchNo(String applyBatchNo) {
    this.applyBatchNo = applyBatchNo;
    return this;
  }

   /**
   * 申请批次号
   * @return applyBatchNo
  **/
  @ApiModelProperty(value = "申请批次号")
  public String getApplyBatchNo() {
    return applyBatchNo;
  }

  public void setApplyBatchNo(String applyBatchNo) {
    this.applyBatchNo = applyBatchNo;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 分组代码  SC@vanke, SC@poly
   * @return groupCode
  **/
  @ApiModelProperty(value = "分组代码  SC@vanke, SC@poly")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyNo(String companyNo) {
    this.companyNo = companyNo;
    return this;
  }

   /**
   * 公司编号：内部供应商或公司编号，需要确保分组下唯一
   * @return companyNo
  **/
  @ApiModelProperty(value = "公司编号：内部供应商或公司编号，需要确保分组下唯一")
  public String getCompanyNo() {
    return companyNo;
  }

  public void setCompanyNo(String companyNo) {
    this.companyNo = companyNo;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyType(String companyType) {
    this.companyType = companyType;
    return this;
  }

   /**
   * 公司类型 1-境内注册公司
   * @return companyType
  **/
  @ApiModelProperty(value = "公司类型 1-境内注册公司")
  public String getCompanyType() {
    return companyType;
  }

  public void setCompanyType(String companyType) {
    this.companyType = companyType;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司全称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司全称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyAddr(String companyAddr) {
    this.companyAddr = companyAddr;
    return this;
  }

   /**
   * 公司地址
   * @return companyAddr
  **/
  @ApiModelProperty(value = "公司地址")
  public String getCompanyAddr() {
    return companyAddr;
  }

  public void setCompanyAddr(String companyAddr) {
    this.companyAddr = companyAddr;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyTel(String companyTel) {
    this.companyTel = companyTel;
    return this;
  }

   /**
   * 公司电话
   * @return companyTel
  **/
  @ApiModelProperty(value = "公司电话")
  public String getCompanyTel() {
    return companyTel;
  }

  public void setCompanyTel(String companyTel) {
    this.companyTel = companyTel;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest taxpayerType(String taxpayerType) {
    this.taxpayerType = taxpayerType;
    return this;
  }

   /**
   * 纳税人类型：0-小规模纳税人 ;1-一般纳税人
   * @return taxpayerType
  **/
  @ApiModelProperty(value = "纳税人类型：0-小规模纳税人 ;1-一般纳税人")
  public String getTaxpayerType() {
    return taxpayerType;
  }

  public void setTaxpayerType(String taxpayerType) {
    this.taxpayerType = taxpayerType;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest contactorName(String contactorName) {
    this.contactorName = contactorName;
    return this;
  }

   /**
   * 联系人姓名
   * @return contactorName
  **/
  @ApiModelProperty(value = "联系人姓名")
  public String getContactorName() {
    return contactorName;
  }

  public void setContactorName(String contactorName) {
    this.contactorName = contactorName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest contactorEmail(String contactorEmail) {
    this.contactorEmail = contactorEmail;
    return this;
  }

   /**
   * 联系人邮箱
   * @return contactorEmail
  **/
  @ApiModelProperty(value = "联系人邮箱")
  public String getContactorEmail() {
    return contactorEmail;
  }

  public void setContactorEmail(String contactorEmail) {
    this.contactorEmail = contactorEmail;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest contactorPhone(String contactorPhone) {
    this.contactorPhone = contactorPhone;
    return this;
  }

   /**
   * 联系人电话
   * @return contactorPhone
  **/
  @ApiModelProperty(value = "联系人电话")
  public String getContactorPhone() {
    return contactorPhone;
  }

  public void setContactorPhone(String contactorPhone) {
    this.contactorPhone = contactorPhone;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest contactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
    return this;
  }

   /**
   * 联系人手机(短信)
   * @return contactorTel
  **/
  @ApiModelProperty(value = "联系人手机(短信)")
  public String getContactorTel() {
    return contactorTel;
  }

  public void setContactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyBankName(String companyBankName) {
    this.companyBankName = companyBankName;
    return this;
  }

   /**
   * 公司银行名称
   * @return companyBankName
  **/
  @ApiModelProperty(value = "公司银行名称")
  public String getCompanyBankName() {
    return companyBankName;
  }

  public void setCompanyBankName(String companyBankName) {
    this.companyBankName = companyBankName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest companyBankAccount(String companyBankAccount) {
    this.companyBankAccount = companyBankAccount;
    return this;
  }

   /**
   * 公司银行账户
   * @return companyBankAccount
  **/
  @ApiModelProperty(value = "公司银行账户")
  public String getCompanyBankAccount() {
    return companyBankAccount;
  }

  public void setCompanyBankAccount(String companyBankAccount) {
    this.companyBankAccount = companyBankAccount;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 开票类型 s-只开专票 c-只开普票 cs-既开普票又开专票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "开票类型 s-只开专票 c-只开普票 cs-既开普票又开专票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest invoiceLimitAmountC(String invoiceLimitAmountC) {
    this.invoiceLimitAmountC = invoiceLimitAmountC;
    return this;
  }

   /**
   * 普票票面限制金额
   * @return invoiceLimitAmountC
  **/
  @ApiModelProperty(value = "普票票面限制金额")
  public String getInvoiceLimitAmountC() {
    return invoiceLimitAmountC;
  }

  public void setInvoiceLimitAmountC(String invoiceLimitAmountC) {
    this.invoiceLimitAmountC = invoiceLimitAmountC;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest invoiceLimitAmountS(String invoiceLimitAmountS) {
    this.invoiceLimitAmountS = invoiceLimitAmountS;
    return this;
  }

   /**
   * 专票票面限制金额
   * @return invoiceLimitAmountS
  **/
  @ApiModelProperty(value = "专票票面限制金额")
  public String getInvoiceLimitAmountS() {
    return invoiceLimitAmountS;
  }

  public void setInvoiceLimitAmountS(String invoiceLimitAmountS) {
    this.invoiceLimitAmountS = invoiceLimitAmountS;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest taxDiskType(String taxDiskType) {
    this.taxDiskType = taxDiskType;
    return this;
  }

   /**
   * 税控盘类型：0-航信;1-百旺，用户权限类型为2、4时必填
   * @return taxDiskType
  **/
  @ApiModelProperty(value = "税控盘类型：0-航信;1-百旺，用户权限类型为2、4时必填")
  public String getTaxDiskType() {
    return taxDiskType;
  }

  public void setTaxDiskType(String taxDiskType) {
    this.taxDiskType = taxDiskType;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest invoiceMaker(String invoiceMaker) {
    this.invoiceMaker = invoiceMaker;
    return this;
  }

   /**
   * 开票用户：单点用户ID，即PDC用户ID
   * @return invoiceMaker
  **/
  @ApiModelProperty(value = "开票用户：单点用户ID，即PDC用户ID")
  public String getInvoiceMaker() {
    return invoiceMaker;
  }

  public void setInvoiceMaker(String invoiceMaker) {
    this.invoiceMaker = invoiceMaker;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest invoiceEmail(String invoiceEmail) {
    this.invoiceEmail = invoiceEmail;
    return this;
  }

   /**
   * 开票用户邮箱，PDC用户名
   * @return invoiceEmail
  **/
  @ApiModelProperty(value = "开票用户邮箱，PDC用户名")
  public String getInvoiceEmail() {
    return invoiceEmail;
  }

  public void setInvoiceEmail(String invoiceEmail) {
    this.invoiceEmail = invoiceEmail;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest applyUserName(String applyUserName) {
    this.applyUserName = applyUserName;
    return this;
  }

   /**
   * 申请人姓名
   * @return applyUserName
  **/
  @ApiModelProperty(value = "申请人姓名")
  public String getApplyUserName() {
    return applyUserName;
  }

  public void setApplyUserName(String applyUserName) {
    this.applyUserName = applyUserName;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest applyUserEmail(String applyUserEmail) {
    this.applyUserEmail = applyUserEmail;
    return this;
  }

   /**
   * 申请人邮箱
   * @return applyUserEmail
  **/
  @ApiModelProperty(value = "申请人邮箱")
  public String getApplyUserEmail() {
    return applyUserEmail;
  }

  public void setApplyUserEmail(String applyUserEmail) {
    this.applyUserEmail = applyUserEmail;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest applyUserPhone(String applyUserPhone) {
    this.applyUserPhone = applyUserPhone;
    return this;
  }

   /**
   * 申请人电话
   * @return applyUserPhone
  **/
  @ApiModelProperty(value = "申请人电话")
  public String getApplyUserPhone() {
    return applyUserPhone;
  }

  public void setApplyUserPhone(String applyUserPhone) {
    this.applyUserPhone = applyUserPhone;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest isCreateUser(String isCreateUser) {
    this.isCreateUser = isCreateUser;
    return this;
  }

   /**
   * 是否新建账号：0-否;1-是；空-自动判断
   * @return isCreateUser
  **/
  @ApiModelProperty(value = "是否新建账号：0-否;1-是；空-自动判断")
  public String getIsCreateUser() {
    return isCreateUser;
  }

  public void setIsCreateUser(String isCreateUser) {
    this.isCreateUser = isCreateUser;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest auditFileUrl(MsCrmAuditFileUrlBean auditFileUrl) {
    this.auditFileUrl = auditFileUrl;
    return this;
  }

   /**
   * 审核材料链接
   * @return auditFileUrl
  **/
  @ApiModelProperty(value = "审核材料链接")
  public MsCrmAuditFileUrlBean getAuditFileUrl() {
    return auditFileUrl;
  }

  public void setAuditFileUrl(MsCrmAuditFileUrlBean auditFileUrl) {
    this.auditFileUrl = auditFileUrl;
  }

  @JsonIgnore
  public MsCrmPolyCmpInfoSyncRequest clickFlag(Boolean clickFlag) {
    this.clickFlag = clickFlag;
    return this;
  }

   /**
   * 是否点开链接
   * @return clickFlag
  **/
  @ApiModelProperty(value = "是否点开链接")
  public Boolean getClickFlag() {
    return clickFlag;
  }

  public void setClickFlag(Boolean clickFlag) {
    this.clickFlag = clickFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmPolyCmpInfoSyncRequest crmPolyCmpInfoSyncRequest = (MsCrmPolyCmpInfoSyncRequest) o;
    return Objects.equals(this.applySerialNo, crmPolyCmpInfoSyncRequest.applySerialNo) &&
        Objects.equals(this.applyBatchNo, crmPolyCmpInfoSyncRequest.applyBatchNo) &&
        Objects.equals(this.groupCode, crmPolyCmpInfoSyncRequest.groupCode) &&
        Objects.equals(this.companyNo, crmPolyCmpInfoSyncRequest.companyNo) &&
        Objects.equals(this.companyType, crmPolyCmpInfoSyncRequest.companyType) &&
        Objects.equals(this.companyTaxNo, crmPolyCmpInfoSyncRequest.companyTaxNo) &&
        Objects.equals(this.companyName, crmPolyCmpInfoSyncRequest.companyName) &&
        Objects.equals(this.companyAddr, crmPolyCmpInfoSyncRequest.companyAddr) &&
        Objects.equals(this.companyTel, crmPolyCmpInfoSyncRequest.companyTel) &&
        Objects.equals(this.taxpayerType, crmPolyCmpInfoSyncRequest.taxpayerType) &&
        Objects.equals(this.contactorName, crmPolyCmpInfoSyncRequest.contactorName) &&
        Objects.equals(this.contactorEmail, crmPolyCmpInfoSyncRequest.contactorEmail) &&
        Objects.equals(this.contactorPhone, crmPolyCmpInfoSyncRequest.contactorPhone) &&
        Objects.equals(this.contactorTel, crmPolyCmpInfoSyncRequest.contactorTel) &&
        Objects.equals(this.companyBankName, crmPolyCmpInfoSyncRequest.companyBankName) &&
        Objects.equals(this.companyBankAccount, crmPolyCmpInfoSyncRequest.companyBankAccount) &&
        Objects.equals(this.cashierName, crmPolyCmpInfoSyncRequest.cashierName) &&
        Objects.equals(this.checkerName, crmPolyCmpInfoSyncRequest.checkerName) &&
        Objects.equals(this.invoiceType, crmPolyCmpInfoSyncRequest.invoiceType) &&
        Objects.equals(this.invoiceLimitAmountC, crmPolyCmpInfoSyncRequest.invoiceLimitAmountC) &&
        Objects.equals(this.invoiceLimitAmountS, crmPolyCmpInfoSyncRequest.invoiceLimitAmountS) &&
        Objects.equals(this.taxDiskType, crmPolyCmpInfoSyncRequest.taxDiskType) &&
        Objects.equals(this.invoiceMaker, crmPolyCmpInfoSyncRequest.invoiceMaker) &&
        Objects.equals(this.invoiceEmail, crmPolyCmpInfoSyncRequest.invoiceEmail) &&
        Objects.equals(this.applyUserName, crmPolyCmpInfoSyncRequest.applyUserName) &&
        Objects.equals(this.applyUserEmail, crmPolyCmpInfoSyncRequest.applyUserEmail) &&
        Objects.equals(this.applyUserPhone, crmPolyCmpInfoSyncRequest.applyUserPhone) &&
        Objects.equals(this.isCreateUser, crmPolyCmpInfoSyncRequest.isCreateUser) &&
        Objects.equals(this.auditFileUrl, crmPolyCmpInfoSyncRequest.auditFileUrl) &&
        Objects.equals(this.clickFlag, crmPolyCmpInfoSyncRequest.clickFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applySerialNo, applyBatchNo, groupCode, companyNo, companyType, companyTaxNo, companyName, companyAddr, companyTel, taxpayerType, contactorName, contactorEmail, contactorPhone, contactorTel, companyBankName, companyBankAccount, cashierName, checkerName, invoiceType, invoiceLimitAmountC, invoiceLimitAmountS, taxDiskType, invoiceMaker, invoiceEmail, applyUserName, applyUserEmail, applyUserPhone, isCreateUser, auditFileUrl, clickFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmPolyCmpInfoSyncRequest {\n");
    
    sb.append("    applySerialNo: ").append(toIndentedString(applySerialNo)).append("\n");
    sb.append("    applyBatchNo: ").append(toIndentedString(applyBatchNo)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    companyNo: ").append(toIndentedString(companyNo)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyAddr: ").append(toIndentedString(companyAddr)).append("\n");
    sb.append("    companyTel: ").append(toIndentedString(companyTel)).append("\n");
    sb.append("    taxpayerType: ").append(toIndentedString(taxpayerType)).append("\n");
    sb.append("    contactorName: ").append(toIndentedString(contactorName)).append("\n");
    sb.append("    contactorEmail: ").append(toIndentedString(contactorEmail)).append("\n");
    sb.append("    contactorPhone: ").append(toIndentedString(contactorPhone)).append("\n");
    sb.append("    contactorTel: ").append(toIndentedString(contactorTel)).append("\n");
    sb.append("    companyBankName: ").append(toIndentedString(companyBankName)).append("\n");
    sb.append("    companyBankAccount: ").append(toIndentedString(companyBankAccount)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceLimitAmountC: ").append(toIndentedString(invoiceLimitAmountC)).append("\n");
    sb.append("    invoiceLimitAmountS: ").append(toIndentedString(invoiceLimitAmountS)).append("\n");
    sb.append("    taxDiskType: ").append(toIndentedString(taxDiskType)).append("\n");
    sb.append("    invoiceMaker: ").append(toIndentedString(invoiceMaker)).append("\n");
    sb.append("    invoiceEmail: ").append(toIndentedString(invoiceEmail)).append("\n");
    sb.append("    applyUserName: ").append(toIndentedString(applyUserName)).append("\n");
    sb.append("    applyUserEmail: ").append(toIndentedString(applyUserEmail)).append("\n");
    sb.append("    applyUserPhone: ").append(toIndentedString(applyUserPhone)).append("\n");
    sb.append("    isCreateUser: ").append(toIndentedString(isCreateUser)).append("\n");
    sb.append("    auditFileUrl: ").append(toIndentedString(auditFileUrl)).append("\n");
    sb.append("    clickFlag: ").append(toIndentedString(clickFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
