package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsDetailRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsDetailRequest {
  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("cooperatorTenantId")
  private Long cooperatorTenantId = null;

  @JsonIgnore
  public MsGoodsDetailRequest goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsGoodsDetailRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsGoodsDetailRequest cooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return cooperatorTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public Long getCooperatorTenantId() {
    return cooperatorTenantId;
  }

  public void setCooperatorTenantId(Long cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsDetailRequest goodsDetailRequest = (MsGoodsDetailRequest) o;
    return Objects.equals(this.goodsNo, goodsDetailRequest.goodsNo) &&
        Objects.equals(this.tenantId, goodsDetailRequest.tenantId) &&
        Objects.equals(this.cooperatorTenantId, goodsDetailRequest.cooperatorTenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsNo, tenantId, cooperatorTenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsDetailRequest {\n");
    
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    cooperatorTenantId: ").append(toIndentedString(cooperatorTenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
