package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsListRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsListRequest {
  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsCode")
  private String goodsCode = null;

  @JsonProperty("cooperatorGoodsName")
  private String cooperatorGoodsName = null;

  @JsonProperty("cooperatorGoodsNo")
  private String cooperatorGoodsNo = null;

  @JsonProperty("cooperatorTenantId")
  private String cooperatorTenantId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGoodsListRequest goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsGoodsListRequest goodsCode(String goodsCode) {
    this.goodsCode = goodsCode;
    return this;
  }

   /**
   * 商品编码
   * @return goodsCode
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsCode() {
    return goodsCode;
  }

  public void setGoodsCode(String goodsCode) {
    this.goodsCode = goodsCode;
  }

  @JsonIgnore
  public MsGoodsListRequest cooperatorGoodsName(String cooperatorGoodsName) {
    this.cooperatorGoodsName = cooperatorGoodsName;
    return this;
  }

   /**
   * 协同方商品名称
   * @return cooperatorGoodsName
  **/
  @ApiModelProperty(value = "协同方商品名称")
  public String getCooperatorGoodsName() {
    return cooperatorGoodsName;
  }

  public void setCooperatorGoodsName(String cooperatorGoodsName) {
    this.cooperatorGoodsName = cooperatorGoodsName;
  }

  @JsonIgnore
  public MsGoodsListRequest cooperatorGoodsNo(String cooperatorGoodsNo) {
    this.cooperatorGoodsNo = cooperatorGoodsNo;
    return this;
  }

   /**
   * 协同方商品编码
   * @return cooperatorGoodsNo
  **/
  @ApiModelProperty(value = "协同方商品编码")
  public String getCooperatorGoodsNo() {
    return cooperatorGoodsNo;
  }

  public void setCooperatorGoodsNo(String cooperatorGoodsNo) {
    this.cooperatorGoodsNo = cooperatorGoodsNo;
  }

  @JsonIgnore
  public MsGoodsListRequest cooperatorTenantId(String cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
    return this;
  }

   /**
   * 协同方租户id
   * @return cooperatorTenantId
  **/
  @ApiModelProperty(value = "协同方租户id")
  public String getCooperatorTenantId() {
    return cooperatorTenantId;
  }

  public void setCooperatorTenantId(String cooperatorTenantId) {
    this.cooperatorTenantId = cooperatorTenantId;
  }

  @JsonIgnore
  public MsGoodsListRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码数
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGoodsListRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页码大小
   * @return pageSize
  **/
  @ApiModelProperty(value = "页码大小")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsGoodsListRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsListRequest goodsListRequest = (MsGoodsListRequest) o;
    return Objects.equals(this.goodsName, goodsListRequest.goodsName) &&
        Objects.equals(this.goodsCode, goodsListRequest.goodsCode) &&
        Objects.equals(this.cooperatorGoodsName, goodsListRequest.cooperatorGoodsName) &&
        Objects.equals(this.cooperatorGoodsNo, goodsListRequest.cooperatorGoodsNo) &&
        Objects.equals(this.cooperatorTenantId, goodsListRequest.cooperatorTenantId) &&
        Objects.equals(this.pageNo, goodsListRequest.pageNo) &&
        Objects.equals(this.pageSize, goodsListRequest.pageSize) &&
        Objects.equals(this.tenantId, goodsListRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsName, goodsCode, cooperatorGoodsName, cooperatorGoodsNo, cooperatorTenantId, pageNo, pageSize, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsListRequest {\n");
    
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsCode: ").append(toIndentedString(goodsCode)).append("\n");
    sb.append("    cooperatorGoodsName: ").append(toIndentedString(cooperatorGoodsName)).append("\n");
    sb.append("    cooperatorGoodsNo: ").append(toIndentedString(cooperatorGoodsNo)).append("\n");
    sb.append("    cooperatorTenantId: ").append(toIndentedString(cooperatorTenantId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
