package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsModel
 */

@JsonInclude(NON_NULL)
public class MsGoodsModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("goodsName")
  private String goodsName = null;

  @JsonProperty("goodsNo")
  private String goodsNo = null;

  @JsonProperty("specification")
  private String specification = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("priceMethod")
  private Integer priceMethod = null;

  @JsonProperty("taxName")
  private String taxName = null;

  @JsonProperty("taxCode")
  private String taxCode = null;

  @JsonProperty("taxShortName")
  private String taxShortName = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("taxId")
  private Long taxId = null;

  @JsonProperty("goodsType")
  private Integer goodsType = null;

  @JsonIgnore
  public MsGoodsModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsGoodsModel goodsName(String goodsName) {
    this.goodsName = goodsName;
    return this;
  }

   /**
   * 商品名称
   * @return goodsName
  **/
  @ApiModelProperty(value = "商品名称")
  public String getGoodsName() {
    return goodsName;
  }

  public void setGoodsName(String goodsName) {
    this.goodsName = goodsName;
  }

  @JsonIgnore
  public MsGoodsModel goodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
    return this;
  }

   /**
   * 商品编码
   * @return goodsNo
  **/
  @ApiModelProperty(value = "商品编码")
  public String getGoodsNo() {
    return goodsNo;
  }

  public void setGoodsNo(String goodsNo) {
    this.goodsNo = goodsNo;
  }

  @JsonIgnore
  public MsGoodsModel specification(String specification) {
    this.specification = specification;
    return this;
  }

   /**
   * 规格型号
   * @return specification
  **/
  @ApiModelProperty(value = "规格型号")
  public String getSpecification() {
    return specification;
  }

  public void setSpecification(String specification) {
    this.specification = specification;
  }

  @JsonIgnore
  public MsGoodsModel quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsGoodsModel unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsGoodsModel priceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 计价方式, 0 = 不含税，1=含税
   * @return priceMethod
  **/
  @ApiModelProperty(value = "计价方式, 0 = 不含税，1=含税")
  public Integer getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Integer priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public MsGoodsModel taxName(String taxName) {
    this.taxName = taxName;
    return this;
  }

   /**
   * 税编名称
   * @return taxName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxName() {
    return taxName;
  }

  public void setTaxName(String taxName) {
    this.taxName = taxName;
  }

  @JsonIgnore
  public MsGoodsModel taxCode(String taxCode) {
    this.taxCode = taxCode;
    return this;
  }

   /**
   * 税收编码
   * @return taxCode
  **/
  @ApiModelProperty(value = "税收编码")
  public String getTaxCode() {
    return taxCode;
  }

  public void setTaxCode(String taxCode) {
    this.taxCode = taxCode;
  }

  @JsonIgnore
  public MsGoodsModel taxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxShortName() {
    return taxShortName;
  }

  public void setTaxShortName(String taxShortName) {
    this.taxShortName = taxShortName;
  }

  @JsonIgnore
  public MsGoodsModel taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsGoodsModel taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受优惠政策， 0 否， 1 是
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受优惠政策， 0 否， 1 是")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public MsGoodsModel taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public MsGoodsModel zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识， 0 出口退税， 1 免税，2 不征税， 2 普通零税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsGoodsModel companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsGoodsModel companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsGoodsModel companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsGoodsModel taxId(Long taxId) {
    this.taxId = taxId;
    return this;
  }

   /**
   * 税编Id
   * @return taxId
  **/
  @ApiModelProperty(value = "税编Id")
  public Long getTaxId() {
    return taxId;
  }

  public void setTaxId(Long taxId) {
    this.taxId = taxId;
  }

  @JsonIgnore
  public MsGoodsModel goodsType(Integer goodsType) {
    this.goodsType = goodsType;
    return this;
  }

   /**
   * 系统商品类型, 0=协同购方，1=协同销方
   * @return goodsType
  **/
  @ApiModelProperty(value = "系统商品类型, 0=协同购方，1=协同销方")
  public Integer getGoodsType() {
    return goodsType;
  }

  public void setGoodsType(Integer goodsType) {
    this.goodsType = goodsType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsModel goodsModel = (MsGoodsModel) o;
    return Objects.equals(this.id, goodsModel.id) &&
        Objects.equals(this.goodsName, goodsModel.goodsName) &&
        Objects.equals(this.goodsNo, goodsModel.goodsNo) &&
        Objects.equals(this.specification, goodsModel.specification) &&
        Objects.equals(this.quantityUnit, goodsModel.quantityUnit) &&
        Objects.equals(this.unitPrice, goodsModel.unitPrice) &&
        Objects.equals(this.priceMethod, goodsModel.priceMethod) &&
        Objects.equals(this.taxName, goodsModel.taxName) &&
        Objects.equals(this.taxCode, goodsModel.taxCode) &&
        Objects.equals(this.taxShortName, goodsModel.taxShortName) &&
        Objects.equals(this.taxRate, goodsModel.taxRate) &&
        Objects.equals(this.taxPre, goodsModel.taxPre) &&
        Objects.equals(this.taxPreCon, goodsModel.taxPreCon) &&
        Objects.equals(this.zeroTax, goodsModel.zeroTax) &&
        Objects.equals(this.companyName, goodsModel.companyName) &&
        Objects.equals(this.companyTaxNo, goodsModel.companyTaxNo) &&
        Objects.equals(this.companyId, goodsModel.companyId) &&
        Objects.equals(this.taxId, goodsModel.taxId) &&
        Objects.equals(this.goodsType, goodsModel.goodsType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, goodsName, goodsNo, specification, quantityUnit, unitPrice, priceMethod, taxName, taxCode, taxShortName, taxRate, taxPre, taxPreCon, zeroTax, companyName, companyTaxNo, companyId, taxId, goodsType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    goodsName: ").append(toIndentedString(goodsName)).append("\n");
    sb.append("    goodsNo: ").append(toIndentedString(goodsNo)).append("\n");
    sb.append("    specification: ").append(toIndentedString(specification)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    taxName: ").append(toIndentedString(taxName)).append("\n");
    sb.append("    taxCode: ").append(toIndentedString(taxCode)).append("\n");
    sb.append("    taxShortName: ").append(toIndentedString(taxShortName)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("    goodsType: ").append(toIndentedString(goodsType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
