package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsRelationAddRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsRelationAddRequest {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("mappingGoodsIds")
  private List<Long> mappingGoodsIds = new ArrayList<Long>();

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGoodsRelationAddRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 商品id
   * @return goodsId
  **/
  @ApiModelProperty(value = "商品id")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public MsGoodsRelationAddRequest mappingGoodsIds(List<Long> mappingGoodsIds) {
    this.mappingGoodsIds = mappingGoodsIds;
    return this;
  }

  public MsGoodsRelationAddRequest addMappingGoodsIdsItem(Long mappingGoodsIdsItem) {
    this.mappingGoodsIds.add(mappingGoodsIdsItem);
    return this;
  }

   /**
   * 映射商品id
   * @return mappingGoodsIds
  **/
  @ApiModelProperty(value = "映射商品id")
  public List<Long> getMappingGoodsIds() {
    return mappingGoodsIds;
  }

  public void setMappingGoodsIds(List<Long> mappingGoodsIds) {
    this.mappingGoodsIds = mappingGoodsIds;
  }

  @JsonIgnore
  public MsGoodsRelationAddRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsRelationAddRequest goodsRelationAddRequest = (MsGoodsRelationAddRequest) o;
    return Objects.equals(this.goodsId, goodsRelationAddRequest.goodsId) &&
        Objects.equals(this.mappingGoodsIds, goodsRelationAddRequest.mappingGoodsIds) &&
        Objects.equals(this.tenantId, goodsRelationAddRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, mappingGoodsIds, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsRelationAddRequest {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    mappingGoodsIds: ").append(toIndentedString(mappingGoodsIds)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
