package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsRelationDeleteRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsRelationDeleteRequest {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGoodsRelationDeleteRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 映射商品id
   * @return goodsId
  **/
  @ApiModelProperty(value = "映射商品id")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public MsGoodsRelationDeleteRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsRelationDeleteRequest goodsRelationDeleteRequest = (MsGoodsRelationDeleteRequest) o;
    return Objects.equals(this.goodsId, goodsRelationDeleteRequest.goodsId) &&
        Objects.equals(this.tenantId, goodsRelationDeleteRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsRelationDeleteRequest {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
