package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import com.xforceplus.ant.system.client.model.MsGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsUpdateRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsUpdateRequest {
  @JsonProperty("goodsModel")
  private MsGoodsModel goodsModel = null;

  @JsonProperty("adverseGoods")
  private List<MsCoopGoodsModel> adverseGoods = new ArrayList<MsCoopGoodsModel>();

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGoodsUpdateRequest goodsModel(MsGoodsModel goodsModel) {
    this.goodsModel = goodsModel;
    return this;
  }

   /**
   * 商品信息
   * @return goodsModel
  **/
  @ApiModelProperty(value = "商品信息")
  public MsGoodsModel getGoodsModel() {
    return goodsModel;
  }

  public void setGoodsModel(MsGoodsModel goodsModel) {
    this.goodsModel = goodsModel;
  }

  @JsonIgnore
  public MsGoodsUpdateRequest adverseGoods(List<MsCoopGoodsModel> adverseGoods) {
    this.adverseGoods = adverseGoods;
    return this;
  }

  public MsGoodsUpdateRequest addAdverseGoodsItem(MsCoopGoodsModel adverseGoodsItem) {
    this.adverseGoods.add(adverseGoodsItem);
    return this;
  }

   /**
   * 商品信息
   * @return adverseGoods
  **/
  @ApiModelProperty(value = "商品信息")
  public List<MsCoopGoodsModel> getAdverseGoods() {
    return adverseGoods;
  }

  public void setAdverseGoods(List<MsCoopGoodsModel> adverseGoods) {
    this.adverseGoods = adverseGoods;
  }

  @JsonIgnore
  public MsGoodsUpdateRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsUpdateRequest goodsUpdateRequest = (MsGoodsUpdateRequest) o;
    return Objects.equals(this.goodsModel, goodsUpdateRequest.goodsModel) &&
        Objects.equals(this.adverseGoods, goodsUpdateRequest.adverseGoods) &&
        Objects.equals(this.tenantId, goodsUpdateRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsModel, adverseGoods, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsUpdateRequest {\n");
    
    sb.append("    goodsModel: ").append(toIndentedString(goodsModel)).append("\n");
    sb.append("    adverseGoods: ").append(toIndentedString(adverseGoods)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
