package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发票统计返回结果
 */
@ApiModel(description = "发票统计返回结果")

@JsonInclude(NON_NULL)
public class MsInvoiceStatisticResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("redAmountWithTax")
  private String redAmountWithTax = null;

  @JsonProperty("blueAmountWithTax")
  private String blueAmountWithTax = null;

  @JsonIgnore
  public MsInvoiceStatisticResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 处理状态 0-失败 1-成功 2-处理中
   * @return code
  **/
  @ApiModelProperty(value = "处理状态 0-失败 1-成功 2-处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsInvoiceStatisticResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsInvoiceStatisticResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsInvoiceStatisticResponse redAmountWithTax(String redAmountWithTax) {
    this.redAmountWithTax = redAmountWithTax;
    return this;
  }

   /**
   * 价税合计红票总金额
   * @return redAmountWithTax
  **/
  @ApiModelProperty(value = "价税合计红票总金额")
  public String getRedAmountWithTax() {
    return redAmountWithTax;
  }

  public void setRedAmountWithTax(String redAmountWithTax) {
    this.redAmountWithTax = redAmountWithTax;
  }

  @JsonIgnore
  public MsInvoiceStatisticResponse blueAmountWithTax(String blueAmountWithTax) {
    this.blueAmountWithTax = blueAmountWithTax;
    return this;
  }

   /**
   * 价税合计蓝票总金额
   * @return blueAmountWithTax
  **/
  @ApiModelProperty(value = "价税合计蓝票总金额")
  public String getBlueAmountWithTax() {
    return blueAmountWithTax;
  }

  public void setBlueAmountWithTax(String blueAmountWithTax) {
    this.blueAmountWithTax = blueAmountWithTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceStatisticResponse invoiceStatisticResponse = (MsInvoiceStatisticResponse) o;
    return Objects.equals(this.code, invoiceStatisticResponse.code) &&
        Objects.equals(this.message, invoiceStatisticResponse.message) &&
        Objects.equals(this.total, invoiceStatisticResponse.total) &&
        Objects.equals(this.redAmountWithTax, invoiceStatisticResponse.redAmountWithTax) &&
        Objects.equals(this.blueAmountWithTax, invoiceStatisticResponse.blueAmountWithTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, redAmountWithTax, blueAmountWithTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceStatisticResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    redAmountWithTax: ").append(toIndentedString(redAmountWithTax)).append("\n");
    sb.append("    blueAmountWithTax: ").append(toIndentedString(blueAmountWithTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
