package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsMsgSendTaskBean
 */

@JsonInclude(NON_NULL)
public class MsMsgSendTaskBean {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("msgType")
  private Integer msgType = null;

  @JsonProperty("msgTitle")
  private String msgTitle = null;

  @JsonProperty("msgTemplateCode")
  private String msgTemplateCode = null;

  @JsonProperty("msgTemplateParam")
  private String msgTemplateParam = null;

  @JsonProperty("msgToUser")
  private String msgToUser = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("planSendTime")
  private String planSendTime = null;

  @JsonProperty("sendTime")
  private String sendTime = null;

  @JsonProperty("sendStatus")
  private Integer sendStatus = null;

  @JsonProperty("sendRemark")
  private String sendRemark = null;

  @JsonIgnore
  public MsMsgSendTaskBean id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsMsgSendTaskBean tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsMsgSendTaskBean msgType(Integer msgType) {
    this.msgType = msgType;
    return this;
  }

   /**
   * 消息类型  0-短信（默认） 1-邮件
   * @return msgType
  **/
  @ApiModelProperty(value = "消息类型  0-短信（默认） 1-邮件")
  public Integer getMsgType() {
    return msgType;
  }

  public void setMsgType(Integer msgType) {
    this.msgType = msgType;
  }

  @JsonIgnore
  public MsMsgSendTaskBean msgTitle(String msgTitle) {
    this.msgTitle = msgTitle;
    return this;
  }

   /**
   * 消息标题
   * @return msgTitle
  **/
  @ApiModelProperty(value = "消息标题")
  public String getMsgTitle() {
    return msgTitle;
  }

  public void setMsgTitle(String msgTitle) {
    this.msgTitle = msgTitle;
  }

  @JsonIgnore
  public MsMsgSendTaskBean msgTemplateCode(String msgTemplateCode) {
    this.msgTemplateCode = msgTemplateCode;
    return this;
  }

   /**
   * 消息模板代码
   * @return msgTemplateCode
  **/
  @ApiModelProperty(value = "消息模板代码")
  public String getMsgTemplateCode() {
    return msgTemplateCode;
  }

  public void setMsgTemplateCode(String msgTemplateCode) {
    this.msgTemplateCode = msgTemplateCode;
  }

  @JsonIgnore
  public MsMsgSendTaskBean msgTemplateParam(String msgTemplateParam) {
    this.msgTemplateParam = msgTemplateParam;
    return this;
  }

   /**
   * 消息模板参数   JSON格式存放
   * @return msgTemplateParam
  **/
  @ApiModelProperty(value = "消息模板参数   JSON格式存放")
  public String getMsgTemplateParam() {
    return msgTemplateParam;
  }

  public void setMsgTemplateParam(String msgTemplateParam) {
    this.msgTemplateParam = msgTemplateParam;
  }

  @JsonIgnore
  public MsMsgSendTaskBean msgToUser(String msgToUser) {
    this.msgToUser = msgToUser;
    return this;
  }

   /**
   * 消息用户   短信存放手机号，邮件存放邮箱地址   JSON数组格式存放，如：[“139111111”,“139222222”]
   * @return msgToUser
  **/
  @ApiModelProperty(value = "消息用户   短信存放手机号，邮件存放邮箱地址   JSON数组格式存放，如：[“139111111”,“139222222”]")
  public String getMsgToUser() {
    return msgToUser;
  }

  public void setMsgToUser(String msgToUser) {
    this.msgToUser = msgToUser;
  }

  @JsonIgnore
  public MsMsgSendTaskBean createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsMsgSendTaskBean planSendTime(String planSendTime) {
    this.planSendTime = planSendTime;
    return this;
  }

   /**
   * 计划发送时间
   * @return planSendTime
  **/
  @ApiModelProperty(value = "计划发送时间")
  public String getPlanSendTime() {
    return planSendTime;
  }

  public void setPlanSendTime(String planSendTime) {
    this.planSendTime = planSendTime;
  }

  @JsonIgnore
  public MsMsgSendTaskBean sendTime(String sendTime) {
    this.sendTime = sendTime;
    return this;
  }

   /**
   * 发送时间
   * @return sendTime
  **/
  @ApiModelProperty(value = "发送时间")
  public String getSendTime() {
    return sendTime;
  }

  public void setSendTime(String sendTime) {
    this.sendTime = sendTime;
  }

  @JsonIgnore
  public MsMsgSendTaskBean sendStatus(Integer sendStatus) {
    this.sendStatus = sendStatus;
    return this;
  }

   /**
   * 发送状态   0-待发送（默认） 1-发送成功  2-发送失败
   * @return sendStatus
  **/
  @ApiModelProperty(value = "发送状态   0-待发送（默认） 1-发送成功  2-发送失败")
  public Integer getSendStatus() {
    return sendStatus;
  }

  public void setSendStatus(Integer sendStatus) {
    this.sendStatus = sendStatus;
  }

  @JsonIgnore
  public MsMsgSendTaskBean sendRemark(String sendRemark) {
    this.sendRemark = sendRemark;
    return this;
  }

   /**
   * 发送备注
   * @return sendRemark
  **/
  @ApiModelProperty(value = "发送备注")
  public String getSendRemark() {
    return sendRemark;
  }

  public void setSendRemark(String sendRemark) {
    this.sendRemark = sendRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMsgSendTaskBean msgSendTaskBean = (MsMsgSendTaskBean) o;
    return Objects.equals(this.id, msgSendTaskBean.id) &&
        Objects.equals(this.tenantId, msgSendTaskBean.tenantId) &&
        Objects.equals(this.msgType, msgSendTaskBean.msgType) &&
        Objects.equals(this.msgTitle, msgSendTaskBean.msgTitle) &&
        Objects.equals(this.msgTemplateCode, msgSendTaskBean.msgTemplateCode) &&
        Objects.equals(this.msgTemplateParam, msgSendTaskBean.msgTemplateParam) &&
        Objects.equals(this.msgToUser, msgSendTaskBean.msgToUser) &&
        Objects.equals(this.createTime, msgSendTaskBean.createTime) &&
        Objects.equals(this.planSendTime, msgSendTaskBean.planSendTime) &&
        Objects.equals(this.sendTime, msgSendTaskBean.sendTime) &&
        Objects.equals(this.sendStatus, msgSendTaskBean.sendStatus) &&
        Objects.equals(this.sendRemark, msgSendTaskBean.sendRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tenantId, msgType, msgTitle, msgTemplateCode, msgTemplateParam, msgToUser, createTime, planSendTime, sendTime, sendStatus, sendRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMsgSendTaskBean {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    msgType: ").append(toIndentedString(msgType)).append("\n");
    sb.append("    msgTitle: ").append(toIndentedString(msgTitle)).append("\n");
    sb.append("    msgTemplateCode: ").append(toIndentedString(msgTemplateCode)).append("\n");
    sb.append("    msgTemplateParam: ").append(toIndentedString(msgTemplateParam)).append("\n");
    sb.append("    msgToUser: ").append(toIndentedString(msgToUser)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    planSendTime: ").append(toIndentedString(planSendTime)).append("\n");
    sb.append("    sendTime: ").append(toIndentedString(sendTime)).append("\n");
    sb.append("    sendStatus: ").append(toIndentedString(sendStatus)).append("\n");
    sb.append("    sendRemark: ").append(toIndentedString(sendRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
