package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsNationalTaxCodeRequest
 */

@JsonInclude(NON_NULL)
public class MsNationalTaxCodeRequest {
  @JsonProperty("goodTaxNo")
  private String goodTaxNo = null;

  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsNationalTaxCodeRequest goodTaxNo(String goodTaxNo) {
    this.goodTaxNo = goodTaxNo;
    return this;
  }

   /**
   * 税收编码
   * @return goodTaxNo
  **/
  @ApiModelProperty(value = "税收编码")
  public String getGoodTaxNo() {
    return goodTaxNo;
  }

  public void setGoodTaxNo(String goodTaxNo) {
    this.goodTaxNo = goodTaxNo;
  }

  @JsonIgnore
  public MsNationalTaxCodeRequest itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * 商品简称
   * @return itemName
  **/
  @ApiModelProperty(value = "商品简称")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public MsNationalTaxCodeRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsNationalTaxCodeRequest nationalTaxCodeRequest = (MsNationalTaxCodeRequest) o;
    return Objects.equals(this.goodTaxNo, nationalTaxCodeRequest.goodTaxNo) &&
        Objects.equals(this.itemName, nationalTaxCodeRequest.itemName) &&
        Objects.equals(this.tenantId, nationalTaxCodeRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodTaxNo, itemName, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsNationalTaxCodeRequest {\n");
    
    sb.append("    goodTaxNo: ").append(toIndentedString(goodTaxNo)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
