package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsOperateLogAddRequest
 */

@JsonInclude(NON_NULL)
public class MsOperateLogAddRequest {
  @JsonProperty("requestParam")
  private String requestParam = null;

  @JsonProperty("requestUrl")
  private String requestUrl = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("operateName")
  private String operateName = null;

  @JsonIgnore
  public MsOperateLogAddRequest requestParam(String requestParam) {
    this.requestParam = requestParam;
    return this;
  }

   /**
   * 接口入参
   * @return requestParam
  **/
  @ApiModelProperty(value = "接口入参")
  public String getRequestParam() {
    return requestParam;
  }

  public void setRequestParam(String requestParam) {
    this.requestParam = requestParam;
  }

  @JsonIgnore
  public MsOperateLogAddRequest requestUrl(String requestUrl) {
    this.requestUrl = requestUrl;
    return this;
  }

   /**
   * 接口地址
   * @return requestUrl
  **/
  @ApiModelProperty(value = "接口地址")
  public String getRequestUrl() {
    return requestUrl;
  }

  public void setRequestUrl(String requestUrl) {
    this.requestUrl = requestUrl;
  }

  @JsonIgnore
  public MsOperateLogAddRequest userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名
   * @return userName
  **/
  @ApiModelProperty(value = "用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public MsOperateLogAddRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsOperateLogAddRequest email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 电子邮件
   * @return email
  **/
  @ApiModelProperty(value = "电子邮件")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public MsOperateLogAddRequest operateName(String operateName) {
    this.operateName = operateName;
    return this;
  }

   /**
   * 操作名称
   * @return operateName
  **/
  @ApiModelProperty(value = "操作名称")
  public String getOperateName() {
    return operateName;
  }

  public void setOperateName(String operateName) {
    this.operateName = operateName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateLogAddRequest operateLogAddRequest = (MsOperateLogAddRequest) o;
    return Objects.equals(this.requestParam, operateLogAddRequest.requestParam) &&
        Objects.equals(this.requestUrl, operateLogAddRequest.requestUrl) &&
        Objects.equals(this.userName, operateLogAddRequest.userName) &&
        Objects.equals(this.userId, operateLogAddRequest.userId) &&
        Objects.equals(this.email, operateLogAddRequest.email) &&
        Objects.equals(this.operateName, operateLogAddRequest.operateName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestParam, requestUrl, userName, userId, email, operateName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateLogAddRequest {\n");
    
    sb.append("    requestParam: ").append(toIndentedString(requestParam)).append("\n");
    sb.append("    requestUrl: ").append(toIndentedString(requestUrl)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    operateName: ").append(toIndentedString(operateName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
