package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsOperateLogModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsOperateLogQueryResponse
 */

@JsonInclude(NON_NULL)
public class MsOperateLogQueryResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsOperateLogModel> result = new ArrayList<MsOperateLogModel>();

  @JsonIgnore
  public MsOperateLogQueryResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 处理状态 0-失败 1-成功
   * @return code
  **/
  @ApiModelProperty(value = "处理状态 0-失败 1-成功")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsOperateLogQueryResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @ApiModelProperty(value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsOperateLogQueryResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsOperateLogQueryResponse result(List<MsOperateLogModel> result) {
    this.result = result;
    return this;
  }

  public MsOperateLogQueryResponse addResultItem(MsOperateLogModel resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 数据
   * @return result
  **/
  @ApiModelProperty(value = "数据")
  public List<MsOperateLogModel> getResult() {
    return result;
  }

  public void setResult(List<MsOperateLogModel> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOperateLogQueryResponse operateLogQueryResponse = (MsOperateLogQueryResponse) o;
    return Objects.equals(this.code, operateLogQueryResponse.code) &&
        Objects.equals(this.message, operateLogQueryResponse.message) &&
        Objects.equals(this.total, operateLogQueryResponse.total) &&
        Objects.equals(this.result, operateLogQueryResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOperateLogQueryResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
