package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 重置待办事项
 */
@ApiModel(description = "重置待办事项")

@JsonInclude(NON_NULL)
public class MsResetBacklogRequest {
  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("taxNoList")
  private List<String> taxNoList = new ArrayList<String>();

  @JsonProperty("opType")
  private Integer opType = null;

  @JsonIgnore
  public MsResetBacklogRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsResetBacklogRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsResetBacklogRequest taxNoList(List<String> taxNoList) {
    this.taxNoList = taxNoList;
    return this;
  }

  public MsResetBacklogRequest addTaxNoListItem(String taxNoListItem) {
    this.taxNoList.add(taxNoListItem);
    return this;
  }

   /**
   * 税号集合
   * @return taxNoList
  **/
  @ApiModelProperty(value = "税号集合")
  public List<String> getTaxNoList() {
    return taxNoList;
  }

  public void setTaxNoList(List<String> taxNoList) {
    this.taxNoList = taxNoList;
  }

  @JsonIgnore
  public MsResetBacklogRequest opType(Integer opType) {
    this.opType = opType;
    return this;
  }

   /**
   * 操作类型 0:结算单和发票 1：结算单系列 2：发票系列 3：系统初始化 4：清除重复
   * @return opType
  **/
  @ApiModelProperty(value = "操作类型 0:结算单和发票 1：结算单系列 2：发票系列 3：系统初始化 4：清除重复")
  public Integer getOpType() {
    return opType;
  }

  public void setOpType(Integer opType) {
    this.opType = opType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsResetBacklogRequest resetBacklogRequest = (MsResetBacklogRequest) o;
    return Objects.equals(this.sellerTenantId, resetBacklogRequest.sellerTenantId) &&
        Objects.equals(this.opUserName, resetBacklogRequest.opUserName) &&
        Objects.equals(this.taxNoList, resetBacklogRequest.taxNoList) &&
        Objects.equals(this.opType, resetBacklogRequest.opType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerTenantId, opUserName, taxNoList, opType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsResetBacklogRequest {\n");
    
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    taxNoList: ").append(toIndentedString(taxNoList)).append("\n");
    sb.append("    opType: ").append(toIndentedString(opType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
