package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 业务数据保存请求
 */
@ApiModel(description = "业务数据保存请求")

@JsonInclude(NON_NULL)
public class MsSaveBusinessDataRequest {
  @JsonProperty("businessId")
  private String businessId = null;

  @JsonProperty("businessData")
  private String businessData = null;

  @JsonProperty("businessType")
  private String businessType = null;

  @JsonIgnore
  public MsSaveBusinessDataRequest businessId(String businessId) {
    this.businessId = businessId;
    return this;
  }

   /**
   * 业务ID
   * @return businessId
  **/
  @ApiModelProperty(value = "业务ID")
  public String getBusinessId() {
    return businessId;
  }

  public void setBusinessId(String businessId) {
    this.businessId = businessId;
  }

  @JsonIgnore
  public MsSaveBusinessDataRequest businessData(String businessData) {
    this.businessData = businessData;
    return this;
  }

   /**
   * 业务数据
   * @return businessData
  **/
  @ApiModelProperty(value = "业务数据")
  public String getBusinessData() {
    return businessData;
  }

  public void setBusinessData(String businessData) {
    this.businessData = businessData;
  }

  @JsonIgnore
  public MsSaveBusinessDataRequest businessType(String businessType) {
    this.businessType = businessType;
    return this;
  }

   /**
   * 业务类型
   * @return businessType
  **/
  @ApiModelProperty(value = "业务类型")
  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSaveBusinessDataRequest saveBusinessDataRequest = (MsSaveBusinessDataRequest) o;
    return Objects.equals(this.businessId, saveBusinessDataRequest.businessId) &&
        Objects.equals(this.businessData, saveBusinessDataRequest.businessData) &&
        Objects.equals(this.businessType, saveBusinessDataRequest.businessType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessId, businessData, businessType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSaveBusinessDataRequest {\n");
    
    sb.append("    businessId: ").append(toIndentedString(businessId)).append("\n");
    sb.append("    businessData: ").append(toIndentedString(businessData)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
