package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 手机验证码登录验证请求
 */
@ApiModel(description = "手机验证码登录验证请求")

@JsonInclude(NON_NULL)
public class MsSsoValidateSmsLoginCodeRequest {
  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("validateCode")
  private String validateCode = null;

  @JsonIgnore
  public MsSsoValidateSmsLoginCodeRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsSsoValidateSmsLoginCodeRequest validateCode(String validateCode) {
    this.validateCode = validateCode;
    return this;
  }

   /**
   * 校验码
   * @return validateCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getValidateCode() {
    return validateCode;
  }

  public void setValidateCode(String validateCode) {
    this.validateCode = validateCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoValidateSmsLoginCodeRequest ssoValidateSmsLoginCodeRequest = (MsSsoValidateSmsLoginCodeRequest) o;
    return Objects.equals(this.userPhone, ssoValidateSmsLoginCodeRequest.userPhone) &&
        Objects.equals(this.validateCode, ssoValidateSmsLoginCodeRequest.validateCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userPhone, validateCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoValidateSmsLoginCodeRequest {\n");
    
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    validateCode: ").append(toIndentedString(validateCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
