package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCCompanyBean
 */

@JsonInclude(NON_NULL)
public class MsTCCompanyBean {
  @JsonProperty("servicePackageCodeList")
  private List<String> servicePackageCodeList = new ArrayList<String>();

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("squota")
  private String squota = null;

  @JsonProperty("cquota")
  private String cquota = null;

  @JsonProperty("juquota")
  private String juquota = null;

  @JsonProperty("cequota")
  private String cequota = null;

  @JsonProperty("bankNo")
  private String bankNo = null;

  @JsonProperty("bankName")
  private String bankName = null;

  @JsonProperty("bankBranchName")
  private String bankBranchName = null;

  @JsonProperty("bankAddr")
  private String bankAddr = null;

  @JsonProperty("bankArea")
  private String bankArea = null;

  @JsonProperty("bankCity")
  private String bankCity = null;

  @JsonProperty("taxpayerQualification")
  private String taxpayerQualification = null;

  @JsonProperty("taxpayerQualificationType")
  private Integer taxpayerQualificationType = null;

  @JsonProperty("businessLicense")
  private String businessLicense = null;

  @JsonProperty("businessScope")
  private String businessScope = null;

  @JsonProperty("businessTimeLong")
  private Integer businessTimeLong = null;

  @JsonProperty("businessStartTime")
  private String businessStartTime = null;

  @JsonProperty("businessEndTime")
  private String businessEndTime = null;

  @JsonProperty("registLocationArea")
  private String registLocationArea = null;

  @JsonProperty("registLocationCity")
  private String registLocationCity = null;

  @JsonProperty("registLocationAddr")
  private String registLocationAddr = null;

  @JsonProperty("locationArea")
  private String locationArea = null;

  @JsonProperty("locationCity")
  private String locationCity = null;

  @JsonProperty("locationAddr")
  private String locationAddr = null;

  @JsonProperty("platManagerStatus")
  private Integer platManagerStatus = null;

  @JsonProperty("managerName")
  private String managerName = null;

  @JsonProperty("managerIdCard")
  private String managerIdCard = null;

  @JsonProperty("managerIdCardFrontPhoto")
  private String managerIdCardFrontPhoto = null;

  @JsonProperty("managerIdCardBackPhoto")
  private String managerIdCardBackPhoto = null;

  @JsonProperty("managerIdCardTimeLong")
  private Integer managerIdCardTimeLong = null;

  @JsonProperty("managerIdCardStartTime")
  private String managerIdCardStartTime = null;

  @JsonProperty("managerIdCardEndTime")
  private String managerIdCardEndTime = null;

  @JsonProperty("managerPhone")
  private String managerPhone = null;

  @JsonProperty("managerLocation")
  private String managerLocation = null;

  @JsonProperty("proxyManagerName")
  private String proxyManagerName = null;

  @JsonProperty("proxyManagerIdCard")
  private String proxyManagerIdCard = null;

  @JsonProperty("proxyManagerIdCardFrontPhoto")
  private String proxyManagerIdCardFrontPhoto = null;

  @JsonProperty("proxyManagerIdCardBackPhoto")
  private String proxyManagerIdCardBackPhoto = null;

  @JsonProperty("proxyManagerIdCardTimeLong")
  private Integer proxyManagerIdCardTimeLong = null;

  @JsonProperty("proxyManagerIdCardStartTime")
  private String proxyManagerIdCardStartTime = null;

  @JsonProperty("proxyManagerIdCardEndTime")
  private String proxyManagerIdCardEndTime = null;

  @JsonProperty("proxyManagerPhone")
  private String proxyManagerPhone = null;

  @JsonIgnore
  public MsTCCompanyBean servicePackageCodeList(List<String> servicePackageCodeList) {
    this.servicePackageCodeList = servicePackageCodeList;
    return this;
  }

  public MsTCCompanyBean addServicePackageCodeListItem(String servicePackageCodeListItem) {
    this.servicePackageCodeList.add(servicePackageCodeListItem);
    return this;
  }

   /**
   * 服务包代码列表
   * @return servicePackageCodeList
  **/
  @ApiModelProperty(value = "服务包代码列表")
  public List<String> getServicePackageCodeList() {
    return servicePackageCodeList;
  }

  public void setServicePackageCodeList(List<String> servicePackageCodeList) {
    this.servicePackageCodeList = servicePackageCodeList;
  }

  @JsonIgnore
  public MsTCCompanyBean companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 企业名称
   * @return companyName
  **/
  @ApiModelProperty(value = "企业名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsTCCompanyBean sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 供应商编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "供应商编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public MsTCCompanyBean taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 企业税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "企业税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsTCCompanyBean squota(String squota) {
    this.squota = squota;
    return this;
  }

   /**
   * 增值税专用发票限额
   * @return squota
  **/
  @ApiModelProperty(value = "增值税专用发票限额")
  public String getSquota() {
    return squota;
  }

  public void setSquota(String squota) {
    this.squota = squota;
  }

  @JsonIgnore
  public MsTCCompanyBean cquota(String cquota) {
    this.cquota = cquota;
    return this;
  }

   /**
   * 增值税普通发票限额
   * @return cquota
  **/
  @ApiModelProperty(value = "增值税普通发票限额")
  public String getCquota() {
    return cquota;
  }

  public void setCquota(String cquota) {
    this.cquota = cquota;
  }

  @JsonIgnore
  public MsTCCompanyBean juquota(String juquota) {
    this.juquota = juquota;
    return this;
  }

   /**
   * 增值税普通发票(卷票）限额
   * @return juquota
  **/
  @ApiModelProperty(value = "增值税普通发票(卷票）限额")
  public String getJuquota() {
    return juquota;
  }

  public void setJuquota(String juquota) {
    this.juquota = juquota;
  }

  @JsonIgnore
  public MsTCCompanyBean cequota(String cequota) {
    this.cequota = cequota;
    return this;
  }

   /**
   * 增值税电子普通发票限额
   * @return cequota
  **/
  @ApiModelProperty(value = "增值税电子普通发票限额")
  public String getCequota() {
    return cequota;
  }

  public void setCequota(String cequota) {
    this.cequota = cequota;
  }

  @JsonIgnore
  public MsTCCompanyBean bankNo(String bankNo) {
    this.bankNo = bankNo;
    return this;
  }

   /**
   * 开户行行号
   * @return bankNo
  **/
  @ApiModelProperty(value = "开户行行号")
  public String getBankNo() {
    return bankNo;
  }

  public void setBankNo(String bankNo) {
    this.bankNo = bankNo;
  }

  @JsonIgnore
  public MsTCCompanyBean bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

   /**
   * 开户行名称
   * @return bankName
  **/
  @ApiModelProperty(value = "开户行名称")
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  @JsonIgnore
  public MsTCCompanyBean bankBranchName(String bankBranchName) {
    this.bankBranchName = bankBranchName;
    return this;
  }

   /**
   * 开户银行支行名称
   * @return bankBranchName
  **/
  @ApiModelProperty(value = "开户银行支行名称")
  public String getBankBranchName() {
    return bankBranchName;
  }

  public void setBankBranchName(String bankBranchName) {
    this.bankBranchName = bankBranchName;
  }

  @JsonIgnore
  public MsTCCompanyBean bankAddr(String bankAddr) {
    this.bankAddr = bankAddr;
    return this;
  }

   /**
   * 开户行地址
   * @return bankAddr
  **/
  @ApiModelProperty(value = "开户行地址")
  public String getBankAddr() {
    return bankAddr;
  }

  public void setBankAddr(String bankAddr) {
    this.bankAddr = bankAddr;
  }

  @JsonIgnore
  public MsTCCompanyBean bankArea(String bankArea) {
    this.bankArea = bankArea;
    return this;
  }

   /**
   * 银行所在省份
   * @return bankArea
  **/
  @ApiModelProperty(value = "银行所在省份")
  public String getBankArea() {
    return bankArea;
  }

  public void setBankArea(String bankArea) {
    this.bankArea = bankArea;
  }

  @JsonIgnore
  public MsTCCompanyBean bankCity(String bankCity) {
    this.bankCity = bankCity;
    return this;
  }

   /**
   * 银行所在市区
   * @return bankCity
  **/
  @ApiModelProperty(value = "银行所在市区")
  public String getBankCity() {
    return bankCity;
  }

  public void setBankCity(String bankCity) {
    this.bankCity = bankCity;
  }

  @JsonIgnore
  public MsTCCompanyBean taxpayerQualification(String taxpayerQualification) {
    this.taxpayerQualification = taxpayerQualification;
    return this;
  }

   /**
   * 纳税人资质证书（图片链接地址）
   * @return taxpayerQualification
  **/
  @ApiModelProperty(value = "纳税人资质证书（图片链接地址）")
  public String getTaxpayerQualification() {
    return taxpayerQualification;
  }

  public void setTaxpayerQualification(String taxpayerQualification) {
    this.taxpayerQualification = taxpayerQualification;
  }

  @JsonIgnore
  public MsTCCompanyBean taxpayerQualificationType(Integer taxpayerQualificationType) {
    this.taxpayerQualificationType = taxpayerQualificationType;
    return this;
  }

   /**
   * 纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人
   * @return taxpayerQualificationType
  **/
  @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")
  public Integer getTaxpayerQualificationType() {
    return taxpayerQualificationType;
  }

  public void setTaxpayerQualificationType(Integer taxpayerQualificationType) {
    this.taxpayerQualificationType = taxpayerQualificationType;
  }

  @JsonIgnore
  public MsTCCompanyBean businessLicense(String businessLicense) {
    this.businessLicense = businessLicense;
    return this;
  }

   /**
   * 营业执照影像（图片链接地址）
   * @return businessLicense
  **/
  @ApiModelProperty(value = "营业执照影像（图片链接地址）")
  public String getBusinessLicense() {
    return businessLicense;
  }

  public void setBusinessLicense(String businessLicense) {
    this.businessLicense = businessLicense;
  }

  @JsonIgnore
  public MsTCCompanyBean businessScope(String businessScope) {
    this.businessScope = businessScope;
    return this;
  }

   /**
   * 企业经营范围
   * @return businessScope
  **/
  @ApiModelProperty(value = "企业经营范围")
  public String getBusinessScope() {
    return businessScope;
  }

  public void setBusinessScope(String businessScope) {
    this.businessScope = businessScope;
  }

  @JsonIgnore
  public MsTCCompanyBean businessTimeLong(Integer businessTimeLong) {
    this.businessTimeLong = businessTimeLong;
    return this;
  }

   /**
   * 营业期限时间是否长期 1：是 0：否
   * @return businessTimeLong
  **/
  @ApiModelProperty(value = "营业期限时间是否长期 1：是 0：否")
  public Integer getBusinessTimeLong() {
    return businessTimeLong;
  }

  public void setBusinessTimeLong(Integer businessTimeLong) {
    this.businessTimeLong = businessTimeLong;
  }

  @JsonIgnore
  public MsTCCompanyBean businessStartTime(String businessStartTime) {
    this.businessStartTime = businessStartTime;
    return this;
  }

   /**
   * 营业期限开始时间 格式：yyyyMMdd
   * @return businessStartTime
  **/
  @ApiModelProperty(value = "营业期限开始时间 格式：yyyyMMdd")
  public String getBusinessStartTime() {
    return businessStartTime;
  }

  public void setBusinessStartTime(String businessStartTime) {
    this.businessStartTime = businessStartTime;
  }

  @JsonIgnore
  public MsTCCompanyBean businessEndTime(String businessEndTime) {
    this.businessEndTime = businessEndTime;
    return this;
  }

   /**
   * 营业期限结束时间 格式：yyyyMMdd
   * @return businessEndTime
  **/
  @ApiModelProperty(value = "营业期限结束时间 格式：yyyyMMdd")
  public String getBusinessEndTime() {
    return businessEndTime;
  }

  public void setBusinessEndTime(String businessEndTime) {
    this.businessEndTime = businessEndTime;
  }

  @JsonIgnore
  public MsTCCompanyBean registLocationArea(String registLocationArea) {
    this.registLocationArea = registLocationArea;
    return this;
  }

   /**
   * 公司注册所在省份
   * @return registLocationArea
  **/
  @ApiModelProperty(value = "公司注册所在省份")
  public String getRegistLocationArea() {
    return registLocationArea;
  }

  public void setRegistLocationArea(String registLocationArea) {
    this.registLocationArea = registLocationArea;
  }

  @JsonIgnore
  public MsTCCompanyBean registLocationCity(String registLocationCity) {
    this.registLocationCity = registLocationCity;
    return this;
  }

   /**
   * 公司注册所在市区
   * @return registLocationCity
  **/
  @ApiModelProperty(value = "公司注册所在市区")
  public String getRegistLocationCity() {
    return registLocationCity;
  }

  public void setRegistLocationCity(String registLocationCity) {
    this.registLocationCity = registLocationCity;
  }

  @JsonIgnore
  public MsTCCompanyBean registLocationAddr(String registLocationAddr) {
    this.registLocationAddr = registLocationAddr;
    return this;
  }

   /**
   * 公司注册所在详细地址
   * @return registLocationAddr
  **/
  @ApiModelProperty(value = "公司注册所在详细地址")
  public String getRegistLocationAddr() {
    return registLocationAddr;
  }

  public void setRegistLocationAddr(String registLocationAddr) {
    this.registLocationAddr = registLocationAddr;
  }

  @JsonIgnore
  public MsTCCompanyBean locationArea(String locationArea) {
    this.locationArea = locationArea;
    return this;
  }

   /**
   * 公司经营所在省份
   * @return locationArea
  **/
  @ApiModelProperty(value = "公司经营所在省份")
  public String getLocationArea() {
    return locationArea;
  }

  public void setLocationArea(String locationArea) {
    this.locationArea = locationArea;
  }

  @JsonIgnore
  public MsTCCompanyBean locationCity(String locationCity) {
    this.locationCity = locationCity;
    return this;
  }

   /**
   * 公司经营所在市区
   * @return locationCity
  **/
  @ApiModelProperty(value = "公司经营所在市区")
  public String getLocationCity() {
    return locationCity;
  }

  public void setLocationCity(String locationCity) {
    this.locationCity = locationCity;
  }

  @JsonIgnore
  public MsTCCompanyBean locationAddr(String locationAddr) {
    this.locationAddr = locationAddr;
    return this;
  }

   /**
   * 公司经营所在详细地址
   * @return locationAddr
  **/
  @ApiModelProperty(value = "公司经营所在详细地址")
  public String getLocationAddr() {
    return locationAddr;
  }

  public void setLocationAddr(String locationAddr) {
    this.locationAddr = locationAddr;
  }

  @JsonIgnore
  public MsTCCompanyBean platManagerStatus(Integer platManagerStatus) {
    this.platManagerStatus = platManagerStatus;
    return this;
  }

   /**
   * 平台管理人身份 0：法定代理人 1：代理人
   * @return platManagerStatus
  **/
  @ApiModelProperty(value = "平台管理人身份 0：法定代理人 1：代理人")
  public Integer getPlatManagerStatus() {
    return platManagerStatus;
  }

  public void setPlatManagerStatus(Integer platManagerStatus) {
    this.platManagerStatus = platManagerStatus;
  }

  @JsonIgnore
  public MsTCCompanyBean managerName(String managerName) {
    this.managerName = managerName;
    return this;
  }

   /**
   * 法人姓名
   * @return managerName
  **/
  @ApiModelProperty(value = "法人姓名")
  public String getManagerName() {
    return managerName;
  }

  public void setManagerName(String managerName) {
    this.managerName = managerName;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCard(String managerIdCard) {
    this.managerIdCard = managerIdCard;
    return this;
  }

   /**
   * 法人身份证
   * @return managerIdCard
  **/
  @ApiModelProperty(value = "法人身份证")
  public String getManagerIdCard() {
    return managerIdCard;
  }

  public void setManagerIdCard(String managerIdCard) {
    this.managerIdCard = managerIdCard;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
    this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
    return this;
  }

   /**
   * 法人证件正面照（图片链接地址）
   * @return managerIdCardFrontPhoto
  **/
  @ApiModelProperty(value = "法人证件正面照（图片链接地址）")
  public String getManagerIdCardFrontPhoto() {
    return managerIdCardFrontPhoto;
  }

  public void setManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
    this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCardBackPhoto(String managerIdCardBackPhoto) {
    this.managerIdCardBackPhoto = managerIdCardBackPhoto;
    return this;
  }

   /**
   * 法人证件背面照（图片链接地址）
   * @return managerIdCardBackPhoto
  **/
  @ApiModelProperty(value = "法人证件背面照（图片链接地址）")
  public String getManagerIdCardBackPhoto() {
    return managerIdCardBackPhoto;
  }

  public void setManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
    this.managerIdCardBackPhoto = managerIdCardBackPhoto;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCardTimeLong(Integer managerIdCardTimeLong) {
    this.managerIdCardTimeLong = managerIdCardTimeLong;
    return this;
  }

   /**
   * 法人证件时间是否长期 1：是 0：否
   * @return managerIdCardTimeLong
  **/
  @ApiModelProperty(value = "法人证件时间是否长期 1：是 0：否")
  public Integer getManagerIdCardTimeLong() {
    return managerIdCardTimeLong;
  }

  public void setManagerIdCardTimeLong(Integer managerIdCardTimeLong) {
    this.managerIdCardTimeLong = managerIdCardTimeLong;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCardStartTime(String managerIdCardStartTime) {
    this.managerIdCardStartTime = managerIdCardStartTime;
    return this;
  }

   /**
   * 法人证件开始时间 格式：yyyyMMdd
   * @return managerIdCardStartTime
  **/
  @ApiModelProperty(value = "法人证件开始时间 格式：yyyyMMdd")
  public String getManagerIdCardStartTime() {
    return managerIdCardStartTime;
  }

  public void setManagerIdCardStartTime(String managerIdCardStartTime) {
    this.managerIdCardStartTime = managerIdCardStartTime;
  }

  @JsonIgnore
  public MsTCCompanyBean managerIdCardEndTime(String managerIdCardEndTime) {
    this.managerIdCardEndTime = managerIdCardEndTime;
    return this;
  }

   /**
   * 法人证件结束时间 格式：yyyyMMdd
   * @return managerIdCardEndTime
  **/
  @ApiModelProperty(value = "法人证件结束时间 格式：yyyyMMdd")
  public String getManagerIdCardEndTime() {
    return managerIdCardEndTime;
  }

  public void setManagerIdCardEndTime(String managerIdCardEndTime) {
    this.managerIdCardEndTime = managerIdCardEndTime;
  }

  @JsonIgnore
  public MsTCCompanyBean managerPhone(String managerPhone) {
    this.managerPhone = managerPhone;
    return this;
  }

   /**
   * 法人联系方式
   * @return managerPhone
  **/
  @ApiModelProperty(value = "法人联系方式")
  public String getManagerPhone() {
    return managerPhone;
  }

  public void setManagerPhone(String managerPhone) {
    this.managerPhone = managerPhone;
  }

  @JsonIgnore
  public MsTCCompanyBean managerLocation(String managerLocation) {
    this.managerLocation = managerLocation;
    return this;
  }

   /**
   * 法人归属地
   * @return managerLocation
  **/
  @ApiModelProperty(value = "法人归属地")
  public String getManagerLocation() {
    return managerLocation;
  }

  public void setManagerLocation(String managerLocation) {
    this.managerLocation = managerLocation;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerName(String proxyManagerName) {
    this.proxyManagerName = proxyManagerName;
    return this;
  }

   /**
   * 代理人姓名
   * @return proxyManagerName
  **/
  @ApiModelProperty(value = "代理人姓名")
  public String getProxyManagerName() {
    return proxyManagerName;
  }

  public void setProxyManagerName(String proxyManagerName) {
    this.proxyManagerName = proxyManagerName;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCard(String proxyManagerIdCard) {
    this.proxyManagerIdCard = proxyManagerIdCard;
    return this;
  }

   /**
   * 代理人身份证
   * @return proxyManagerIdCard
  **/
  @ApiModelProperty(value = "代理人身份证")
  public String getProxyManagerIdCard() {
    return proxyManagerIdCard;
  }

  public void setProxyManagerIdCard(String proxyManagerIdCard) {
    this.proxyManagerIdCard = proxyManagerIdCard;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
    this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
    return this;
  }

   /**
   * 代理人证件正面照（图片链接地址）
   * @return proxyManagerIdCardFrontPhoto
  **/
  @ApiModelProperty(value = "代理人证件正面照（图片链接地址）")
  public String getProxyManagerIdCardFrontPhoto() {
    return proxyManagerIdCardFrontPhoto;
  }

  public void setProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
    this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
    this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
    return this;
  }

   /**
   * 代理人证件背面照（图片链接地址）
   * @return proxyManagerIdCardBackPhoto
  **/
  @ApiModelProperty(value = "代理人证件背面照（图片链接地址）")
  public String getProxyManagerIdCardBackPhoto() {
    return proxyManagerIdCardBackPhoto;
  }

  public void setProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
    this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCardTimeLong(Integer proxyManagerIdCardTimeLong) {
    this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
    return this;
  }

   /**
   * 代理人证件时间是否长期 1：是 0：否
   * @return proxyManagerIdCardTimeLong
  **/
  @ApiModelProperty(value = "代理人证件时间是否长期 1：是 0：否")
  public Integer getProxyManagerIdCardTimeLong() {
    return proxyManagerIdCardTimeLong;
  }

  public void setProxyManagerIdCardTimeLong(Integer proxyManagerIdCardTimeLong) {
    this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
    this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
    return this;
  }

   /**
   * 代理人证件开始时间 格式：yyyyMMdd
   * @return proxyManagerIdCardStartTime
  **/
  @ApiModelProperty(value = "代理人证件开始时间 格式：yyyyMMdd")
  public String getProxyManagerIdCardStartTime() {
    return proxyManagerIdCardStartTime;
  }

  public void setProxyManagerIdCardStartTime(String proxyManagerIdCardStartTime) {
    this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
    this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
    return this;
  }

   /**
   * 代理人证件结束时间 格式：yyyyMMdd
   * @return proxyManagerIdCardEndTime
  **/
  @ApiModelProperty(value = "代理人证件结束时间 格式：yyyyMMdd")
  public String getProxyManagerIdCardEndTime() {
    return proxyManagerIdCardEndTime;
  }

  public void setProxyManagerIdCardEndTime(String proxyManagerIdCardEndTime) {
    this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
  }

  @JsonIgnore
  public MsTCCompanyBean proxyManagerPhone(String proxyManagerPhone) {
    this.proxyManagerPhone = proxyManagerPhone;
    return this;
  }

   /**
   * 代理人联系方式
   * @return proxyManagerPhone
  **/
  @ApiModelProperty(value = "代理人联系方式")
  public String getProxyManagerPhone() {
    return proxyManagerPhone;
  }

  public void setProxyManagerPhone(String proxyManagerPhone) {
    this.proxyManagerPhone = proxyManagerPhone;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCCompanyBean tcCompanyBean = (MsTCCompanyBean) o;
    return Objects.equals(this.servicePackageCodeList, tcCompanyBean.servicePackageCodeList) &&
        Objects.equals(this.companyName, tcCompanyBean.companyName) &&
        Objects.equals(this.sellerNo, tcCompanyBean.sellerNo) &&
        Objects.equals(this.taxNum, tcCompanyBean.taxNum) &&
        Objects.equals(this.squota, tcCompanyBean.squota) &&
        Objects.equals(this.cquota, tcCompanyBean.cquota) &&
        Objects.equals(this.juquota, tcCompanyBean.juquota) &&
        Objects.equals(this.cequota, tcCompanyBean.cequota) &&
        Objects.equals(this.bankNo, tcCompanyBean.bankNo) &&
        Objects.equals(this.bankName, tcCompanyBean.bankName) &&
        Objects.equals(this.bankBranchName, tcCompanyBean.bankBranchName) &&
        Objects.equals(this.bankAddr, tcCompanyBean.bankAddr) &&
        Objects.equals(this.bankArea, tcCompanyBean.bankArea) &&
        Objects.equals(this.bankCity, tcCompanyBean.bankCity) &&
        Objects.equals(this.taxpayerQualification, tcCompanyBean.taxpayerQualification) &&
        Objects.equals(this.taxpayerQualificationType, tcCompanyBean.taxpayerQualificationType) &&
        Objects.equals(this.businessLicense, tcCompanyBean.businessLicense) &&
        Objects.equals(this.businessScope, tcCompanyBean.businessScope) &&
        Objects.equals(this.businessTimeLong, tcCompanyBean.businessTimeLong) &&
        Objects.equals(this.businessStartTime, tcCompanyBean.businessStartTime) &&
        Objects.equals(this.businessEndTime, tcCompanyBean.businessEndTime) &&
        Objects.equals(this.registLocationArea, tcCompanyBean.registLocationArea) &&
        Objects.equals(this.registLocationCity, tcCompanyBean.registLocationCity) &&
        Objects.equals(this.registLocationAddr, tcCompanyBean.registLocationAddr) &&
        Objects.equals(this.locationArea, tcCompanyBean.locationArea) &&
        Objects.equals(this.locationCity, tcCompanyBean.locationCity) &&
        Objects.equals(this.locationAddr, tcCompanyBean.locationAddr) &&
        Objects.equals(this.platManagerStatus, tcCompanyBean.platManagerStatus) &&
        Objects.equals(this.managerName, tcCompanyBean.managerName) &&
        Objects.equals(this.managerIdCard, tcCompanyBean.managerIdCard) &&
        Objects.equals(this.managerIdCardFrontPhoto, tcCompanyBean.managerIdCardFrontPhoto) &&
        Objects.equals(this.managerIdCardBackPhoto, tcCompanyBean.managerIdCardBackPhoto) &&
        Objects.equals(this.managerIdCardTimeLong, tcCompanyBean.managerIdCardTimeLong) &&
        Objects.equals(this.managerIdCardStartTime, tcCompanyBean.managerIdCardStartTime) &&
        Objects.equals(this.managerIdCardEndTime, tcCompanyBean.managerIdCardEndTime) &&
        Objects.equals(this.managerPhone, tcCompanyBean.managerPhone) &&
        Objects.equals(this.managerLocation, tcCompanyBean.managerLocation) &&
        Objects.equals(this.proxyManagerName, tcCompanyBean.proxyManagerName) &&
        Objects.equals(this.proxyManagerIdCard, tcCompanyBean.proxyManagerIdCard) &&
        Objects.equals(this.proxyManagerIdCardFrontPhoto, tcCompanyBean.proxyManagerIdCardFrontPhoto) &&
        Objects.equals(this.proxyManagerIdCardBackPhoto, tcCompanyBean.proxyManagerIdCardBackPhoto) &&
        Objects.equals(this.proxyManagerIdCardTimeLong, tcCompanyBean.proxyManagerIdCardTimeLong) &&
        Objects.equals(this.proxyManagerIdCardStartTime, tcCompanyBean.proxyManagerIdCardStartTime) &&
        Objects.equals(this.proxyManagerIdCardEndTime, tcCompanyBean.proxyManagerIdCardEndTime) &&
        Objects.equals(this.proxyManagerPhone, tcCompanyBean.proxyManagerPhone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(servicePackageCodeList, companyName, sellerNo, taxNum, squota, cquota, juquota, cequota, bankNo, bankName, bankBranchName, bankAddr, bankArea, bankCity, taxpayerQualification, taxpayerQualificationType, businessLicense, businessScope, businessTimeLong, businessStartTime, businessEndTime, registLocationArea, registLocationCity, registLocationAddr, locationArea, locationCity, locationAddr, platManagerStatus, managerName, managerIdCard, managerIdCardFrontPhoto, managerIdCardBackPhoto, managerIdCardTimeLong, managerIdCardStartTime, managerIdCardEndTime, managerPhone, managerLocation, proxyManagerName, proxyManagerIdCard, proxyManagerIdCardFrontPhoto, proxyManagerIdCardBackPhoto, proxyManagerIdCardTimeLong, proxyManagerIdCardStartTime, proxyManagerIdCardEndTime, proxyManagerPhone);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCCompanyBean {\n");
    
    sb.append("    servicePackageCodeList: ").append(toIndentedString(servicePackageCodeList)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    squota: ").append(toIndentedString(squota)).append("\n");
    sb.append("    cquota: ").append(toIndentedString(cquota)).append("\n");
    sb.append("    juquota: ").append(toIndentedString(juquota)).append("\n");
    sb.append("    cequota: ").append(toIndentedString(cequota)).append("\n");
    sb.append("    bankNo: ").append(toIndentedString(bankNo)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankBranchName: ").append(toIndentedString(bankBranchName)).append("\n");
    sb.append("    bankAddr: ").append(toIndentedString(bankAddr)).append("\n");
    sb.append("    bankArea: ").append(toIndentedString(bankArea)).append("\n");
    sb.append("    bankCity: ").append(toIndentedString(bankCity)).append("\n");
    sb.append("    taxpayerQualification: ").append(toIndentedString(taxpayerQualification)).append("\n");
    sb.append("    taxpayerQualificationType: ").append(toIndentedString(taxpayerQualificationType)).append("\n");
    sb.append("    businessLicense: ").append(toIndentedString(businessLicense)).append("\n");
    sb.append("    businessScope: ").append(toIndentedString(businessScope)).append("\n");
    sb.append("    businessTimeLong: ").append(toIndentedString(businessTimeLong)).append("\n");
    sb.append("    businessStartTime: ").append(toIndentedString(businessStartTime)).append("\n");
    sb.append("    businessEndTime: ").append(toIndentedString(businessEndTime)).append("\n");
    sb.append("    registLocationArea: ").append(toIndentedString(registLocationArea)).append("\n");
    sb.append("    registLocationCity: ").append(toIndentedString(registLocationCity)).append("\n");
    sb.append("    registLocationAddr: ").append(toIndentedString(registLocationAddr)).append("\n");
    sb.append("    locationArea: ").append(toIndentedString(locationArea)).append("\n");
    sb.append("    locationCity: ").append(toIndentedString(locationCity)).append("\n");
    sb.append("    locationAddr: ").append(toIndentedString(locationAddr)).append("\n");
    sb.append("    platManagerStatus: ").append(toIndentedString(platManagerStatus)).append("\n");
    sb.append("    managerName: ").append(toIndentedString(managerName)).append("\n");
    sb.append("    managerIdCard: ").append(toIndentedString(managerIdCard)).append("\n");
    sb.append("    managerIdCardFrontPhoto: ").append(toIndentedString(managerIdCardFrontPhoto)).append("\n");
    sb.append("    managerIdCardBackPhoto: ").append(toIndentedString(managerIdCardBackPhoto)).append("\n");
    sb.append("    managerIdCardTimeLong: ").append(toIndentedString(managerIdCardTimeLong)).append("\n");
    sb.append("    managerIdCardStartTime: ").append(toIndentedString(managerIdCardStartTime)).append("\n");
    sb.append("    managerIdCardEndTime: ").append(toIndentedString(managerIdCardEndTime)).append("\n");
    sb.append("    managerPhone: ").append(toIndentedString(managerPhone)).append("\n");
    sb.append("    managerLocation: ").append(toIndentedString(managerLocation)).append("\n");
    sb.append("    proxyManagerName: ").append(toIndentedString(proxyManagerName)).append("\n");
    sb.append("    proxyManagerIdCard: ").append(toIndentedString(proxyManagerIdCard)).append("\n");
    sb.append("    proxyManagerIdCardFrontPhoto: ").append(toIndentedString(proxyManagerIdCardFrontPhoto)).append("\n");
    sb.append("    proxyManagerIdCardBackPhoto: ").append(toIndentedString(proxyManagerIdCardBackPhoto)).append("\n");
    sb.append("    proxyManagerIdCardTimeLong: ").append(toIndentedString(proxyManagerIdCardTimeLong)).append("\n");
    sb.append("    proxyManagerIdCardStartTime: ").append(toIndentedString(proxyManagerIdCardStartTime)).append("\n");
    sb.append("    proxyManagerIdCardEndTime: ").append(toIndentedString(proxyManagerIdCardEndTime)).append("\n");
    sb.append("    proxyManagerPhone: ").append(toIndentedString(proxyManagerPhone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
