package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 合并服务包请求
 */
@ApiModel(description = "合并服务包请求")

@JsonInclude(NON_NULL)
public class MsTCMergeServicePackageRequest {
  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("serviceCode")
  private List<String> serviceCode = new ArrayList<String>();

  @JsonIgnore
  public MsTCMergeServicePackageRequest companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司ID
   * @return companyId
  **/
  @ApiModelProperty(value = "公司ID")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsTCMergeServicePackageRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 公司税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "公司税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsTCMergeServicePackageRequest serviceCode(List<String> serviceCode) {
    this.serviceCode = serviceCode;
    return this;
  }

  public MsTCMergeServicePackageRequest addServiceCodeItem(String serviceCodeItem) {
    this.serviceCode.add(serviceCodeItem);
    return this;
  }

   /**
   * 新增服务包
   * @return serviceCode
  **/
  @ApiModelProperty(value = "新增服务包")
  public List<String> getServiceCode() {
    return serviceCode;
  }

  public void setServiceCode(List<String> serviceCode) {
    this.serviceCode = serviceCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCMergeServicePackageRequest tcMergeServicePackageRequest = (MsTCMergeServicePackageRequest) o;
    return Objects.equals(this.companyId, tcMergeServicePackageRequest.companyId) &&
        Objects.equals(this.taxNum, tcMergeServicePackageRequest.taxNum) &&
        Objects.equals(this.serviceCode, tcMergeServicePackageRequest.serviceCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, taxNum, serviceCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCMergeServicePackageRequest {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    serviceCode: ").append(toIndentedString(serviceCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
