package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTCMergeServicePackageResponse
 */

@JsonInclude(NON_NULL)
public class MsTCMergeServicePackageResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("mergedPackageIdList")
  private List<String> mergedPackageIdList = new ArrayList<String>();

  @JsonIgnore
  public MsTCMergeServicePackageResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code
   * @return code
  **/
  @ApiModelProperty(value = "return code")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsTCMergeServicePackageResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsTCMergeServicePackageResponse mergedPackageIdList(List<String> mergedPackageIdList) {
    this.mergedPackageIdList = mergedPackageIdList;
    return this;
  }

  public MsTCMergeServicePackageResponse addMergedPackageIdListItem(String mergedPackageIdListItem) {
    this.mergedPackageIdList.add(mergedPackageIdListItem);
    return this;
  }

   /**
   * 合并后服务包ID列表
   * @return mergedPackageIdList
  **/
  @ApiModelProperty(value = "合并后服务包ID列表")
  public List<String> getMergedPackageIdList() {
    return mergedPackageIdList;
  }

  public void setMergedPackageIdList(List<String> mergedPackageIdList) {
    this.mergedPackageIdList = mergedPackageIdList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCMergeServicePackageResponse tcMergeServicePackageResponse = (MsTCMergeServicePackageResponse) o;
    return Objects.equals(this.code, tcMergeServicePackageResponse.code) &&
        Objects.equals(this.message, tcMergeServicePackageResponse.message) &&
        Objects.equals(this.mergedPackageIdList, tcMergeServicePackageResponse.mergedPackageIdList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, mergedPackageIdList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCMergeServicePackageResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    mergedPackageIdList: ").append(toIndentedString(mergedPackageIdList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
