package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTCCompanyBean;
import com.xforceplus.ant.system.client.model.MsTCCoopBean;
import com.xforceplus.ant.system.client.model.MsTCTenantBean;
import com.xforceplus.ant.system.client.model.MsTCUserBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 一站式入驻请求
 */
@ApiModel(description = "一站式入驻请求")

@JsonInclude(NON_NULL)
public class MsTCOneStopEnterRequest {
  @JsonProperty("coop")
  private MsTCCoopBean coop = null;

  @JsonProperty("tenant")
  private MsTCTenantBean tenant = null;

  @JsonProperty("user")
  private MsTCUserBean user = null;

  @JsonProperty("company")
  private MsTCCompanyBean company = null;

  @JsonIgnore
  public MsTCOneStopEnterRequest coop(MsTCCoopBean coop) {
    this.coop = coop;
    return this;
  }

   /**
   * 协同信息
   * @return coop
  **/
  @ApiModelProperty(value = "协同信息")
  public MsTCCoopBean getCoop() {
    return coop;
  }

  public void setCoop(MsTCCoopBean coop) {
    this.coop = coop;
  }

  @JsonIgnore
  public MsTCOneStopEnterRequest tenant(MsTCTenantBean tenant) {
    this.tenant = tenant;
    return this;
  }

   /**
   * 租户信息
   * @return tenant
  **/
  @ApiModelProperty(value = "租户信息")
  public MsTCTenantBean getTenant() {
    return tenant;
  }

  public void setTenant(MsTCTenantBean tenant) {
    this.tenant = tenant;
  }

  @JsonIgnore
  public MsTCOneStopEnterRequest user(MsTCUserBean user) {
    this.user = user;
    return this;
  }

   /**
   * 用户信息
   * @return user
  **/
  @ApiModelProperty(value = "用户信息")
  public MsTCUserBean getUser() {
    return user;
  }

  public void setUser(MsTCUserBean user) {
    this.user = user;
  }

  @JsonIgnore
  public MsTCOneStopEnterRequest company(MsTCCompanyBean company) {
    this.company = company;
    return this;
  }

   /**
   * 公司信息
   * @return company
  **/
  @ApiModelProperty(value = "公司信息")
  public MsTCCompanyBean getCompany() {
    return company;
  }

  public void setCompany(MsTCCompanyBean company) {
    this.company = company;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCOneStopEnterRequest tcOneStopEnterRequest = (MsTCOneStopEnterRequest) o;
    return Objects.equals(this.coop, tcOneStopEnterRequest.coop) &&
        Objects.equals(this.tenant, tcOneStopEnterRequest.tenant) &&
        Objects.equals(this.user, tcOneStopEnterRequest.user) &&
        Objects.equals(this.company, tcOneStopEnterRequest.company);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coop, tenant, user, company);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCOneStopEnterRequest {\n");
    
    sb.append("    coop: ").append(toIndentedString(coop)).append("\n");
    sb.append("    tenant: ").append(toIndentedString(tenant)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
