package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 用户注册请求
 */
@ApiModel(description = "用户注册请求")

@JsonInclude(NON_NULL)
public class MsTCUserRegisterRequest {
  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonProperty("userPhone")
  private String userPhone = null;

  @JsonProperty("validateCode")
  private String validateCode = null;

  @JsonIgnore
  public MsTCUserRegisterRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 公司税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "公司税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }

  @JsonIgnore
  public MsTCUserRegisterRequest userPhone(String userPhone) {
    this.userPhone = userPhone;
    return this;
  }

   /**
   * 用户手机号
   * @return userPhone
  **/
  @ApiModelProperty(value = "用户手机号")
  public String getUserPhone() {
    return userPhone;
  }

  public void setUserPhone(String userPhone) {
    this.userPhone = userPhone;
  }

  @JsonIgnore
  public MsTCUserRegisterRequest validateCode(String validateCode) {
    this.validateCode = validateCode;
    return this;
  }

   /**
   * 校验码
   * @return validateCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getValidateCode() {
    return validateCode;
  }

  public void setValidateCode(String validateCode) {
    this.validateCode = validateCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTCUserRegisterRequest tcUserRegisterRequest = (MsTCUserRegisterRequest) o;
    return Objects.equals(this.taxNum, tcUserRegisterRequest.taxNum) &&
        Objects.equals(this.userPhone, tcUserRegisterRequest.userPhone) &&
        Objects.equals(this.validateCode, tcUserRegisterRequest.validateCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNum, userPhone, validateCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTCUserRegisterRequest {\n");
    
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("    userPhone: ").append(toIndentedString(userPhone)).append("\n");
    sb.append("    validateCode: ").append(toIndentedString(validateCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
