package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTaxCodeModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTaxCodeUpdateRequest
 */

@JsonInclude(NON_NULL)
public class MsTaxCodeUpdateRequest {
  @JsonProperty("taxConvertCodeModel")
  private MsTaxCodeModel taxConvertCodeModel = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsTaxCodeUpdateRequest taxConvertCodeModel(MsTaxCodeModel taxConvertCodeModel) {
    this.taxConvertCodeModel = taxConvertCodeModel;
    return this;
  }

   /**
   * 税编信息
   * @return taxConvertCodeModel
  **/
  @ApiModelProperty(value = "税编信息")
  public MsTaxCodeModel getTaxConvertCodeModel() {
    return taxConvertCodeModel;
  }

  public void setTaxConvertCodeModel(MsTaxCodeModel taxConvertCodeModel) {
    this.taxConvertCodeModel = taxConvertCodeModel;
  }

  @JsonIgnore
  public MsTaxCodeUpdateRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxCodeUpdateRequest taxCodeUpdateRequest = (MsTaxCodeUpdateRequest) o;
    return Objects.equals(this.taxConvertCodeModel, taxCodeUpdateRequest.taxConvertCodeModel) &&
        Objects.equals(this.tenantId, taxCodeUpdateRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxConvertCodeModel, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxCodeUpdateRequest {\n");
    
    sb.append("    taxConvertCodeModel: ").append(toIndentedString(taxConvertCodeModel)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
