package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * general nationalEntity object
 */
@ApiModel(description = "general nationalEntity object")

@JsonInclude(NON_NULL)
public class MsTaxNationalCode {
  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("taxcodeName")
  private String taxcodeName = null;

  @JsonProperty("taxcodeShortName")
  private String taxcodeShortName = null;

  @JsonProperty("explainDes")
  private String explainDes = null;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("splitCode")
  private String splitCode = null;

  @JsonProperty("itemTypeCode")
  private String itemTypeCode = null;

  @JsonIgnore
  public MsTaxNationalCode goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public MsTaxNationalCode taxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
    return this;
  }

   /**
   * 税编名称
   * @return taxcodeName
  **/
  @ApiModelProperty(value = "税编名称")
  public String getTaxcodeName() {
    return taxcodeName;
  }

  public void setTaxcodeName(String taxcodeName) {
    this.taxcodeName = taxcodeName;
  }

  @JsonIgnore
  public MsTaxNationalCode taxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
    return this;
  }

   /**
   * 税编简称
   * @return taxcodeShortName
  **/
  @ApiModelProperty(value = "税编简称")
  public String getTaxcodeShortName() {
    return taxcodeShortName;
  }

  public void setTaxcodeShortName(String taxcodeShortName) {
    this.taxcodeShortName = taxcodeShortName;
  }

  @JsonIgnore
  public MsTaxNationalCode explainDes(String explainDes) {
    this.explainDes = explainDes;
    return this;
  }

   /**
   * 说明
   * @return explainDes
  **/
  @ApiModelProperty(value = "说明")
  public String getExplainDes() {
    return explainDes;
  }

  public void setExplainDes(String explainDes) {
    this.explainDes = explainDes;
  }

  @JsonIgnore
  public MsTaxNationalCode version(String version) {
    this.version = version;
    return this;
  }

   /**
   * 版本
   * @return version
  **/
  @ApiModelProperty(value = "版本")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @JsonIgnore
  public MsTaxNationalCode splitCode(String splitCode) {
    this.splitCode = splitCode;
    return this;
  }

   /**
   * 是否可以混开
   * @return splitCode
  **/
  @ApiModelProperty(value = "是否可以混开")
  public String getSplitCode() {
    return splitCode;
  }

  public void setSplitCode(String splitCode) {
    this.splitCode = splitCode;
  }

  @JsonIgnore
  public MsTaxNationalCode itemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
    return this;
  }

   /**
   * 分类码
   * @return itemTypeCode
  **/
  @ApiModelProperty(value = "分类码")
  public String getItemTypeCode() {
    return itemTypeCode;
  }

  public void setItemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxNationalCode taxNationalCode = (MsTaxNationalCode) o;
    return Objects.equals(this.goodsTaxNo, taxNationalCode.goodsTaxNo) &&
        Objects.equals(this.taxcodeName, taxNationalCode.taxcodeName) &&
        Objects.equals(this.taxcodeShortName, taxNationalCode.taxcodeShortName) &&
        Objects.equals(this.explainDes, taxNationalCode.explainDes) &&
        Objects.equals(this.version, taxNationalCode.version) &&
        Objects.equals(this.splitCode, taxNationalCode.splitCode) &&
        Objects.equals(this.itemTypeCode, taxNationalCode.itemTypeCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsTaxNo, taxcodeName, taxcodeShortName, explainDes, version, splitCode, itemTypeCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxNationalCode {\n");
    
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    taxcodeName: ").append(toIndentedString(taxcodeName)).append("\n");
    sb.append("    taxcodeShortName: ").append(toIndentedString(taxcodeShortName)).append("\n");
    sb.append("    explainDes: ").append(toIndentedString(explainDes)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    splitCode: ").append(toIndentedString(splitCode)).append("\n");
    sb.append("    itemTypeCode: ").append(toIndentedString(itemTypeCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
