package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsTowerImportFileInfo
 */

@JsonInclude(NON_NULL)
public class MsTowerImportFileInfo {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("url")
  private String url = null;

  @JsonProperty("originFileName")
  private String originFileName = null;

  @JsonIgnore
  public MsTowerImportFileInfo id(String id) {
    this.id = id;
    return this;
  }

   /**
   * 文件服务id
   * @return id
  **/
  @ApiModelProperty(value = "文件服务id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @JsonIgnore
  public MsTowerImportFileInfo url(String url) {
    this.url = url;
    return this;
  }

   /**
   * 文件地址
   * @return url
  **/
  @ApiModelProperty(value = "文件地址")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @JsonIgnore
  public MsTowerImportFileInfo originFileName(String originFileName) {
    this.originFileName = originFileName;
    return this;
  }

   /**
   * 原文件名
   * @return originFileName
  **/
  @ApiModelProperty(value = "原文件名")
  public String getOriginFileName() {
    return originFileName;
  }

  public void setOriginFileName(String originFileName) {
    this.originFileName = originFileName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTowerImportFileInfo towerImportFileInfo = (MsTowerImportFileInfo) o;
    return Objects.equals(this.id, towerImportFileInfo.id) &&
        Objects.equals(this.url, towerImportFileInfo.url) &&
        Objects.equals(this.originFileName, towerImportFileInfo.originFileName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, url, originFileName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTowerImportFileInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    originFileName: ").append(toIndentedString(originFileName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
