package com.xforceplus.ant.system.client.api;

import com.xforceplus.ant.system.client.model.MsCategoryUpdateRequest;
import com.xforceplus.ant.system.client.model.MsGoodsAddRequest;
import com.xforceplus.ant.system.client.model.MsGoodsDetailRequest;
import com.xforceplus.ant.system.client.model.MsGoodsDetailResponse;
import com.xforceplus.ant.system.client.model.MsGoodsDiscountUploadRequest;
import com.xforceplus.ant.system.client.model.MsGoodsUpdateRequest;
import com.xforceplus.ant.system.client.model.MsGoodsUploadRequest;
import com.xforceplus.ant.system.client.model.MsModifyGoodsRequest;
import com.xforceplus.ant.system.client.model.MsNationalTaxCodeRequest;
import com.xforceplus.ant.system.client.model.MsNationalTaxCodeResponse;
import com.xforceplus.ant.system.client.model.MsQueryGoodsListRequest;
import com.xforceplus.ant.system.client.model.MsQueryGoodsListResponse;
import com.xforceplus.ant.system.client.model.MsResponse;
import com.xforceplus.ant.system.client.model.MsTaxCodeStructureResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "goods", description = "the goods API")
public interface GoodsApi {

    @ApiOperation(value = "添加商品", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/add",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse add(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsAddRequest request);


    @ApiOperation(value = "管理员上传商品", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/adminUpload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse adminUpload(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsUploadRequest request);


    @ApiOperation(value = "查询国税库", notes = "", response = MsNationalTaxCodeResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsNationalTaxCodeResponse.class) })
    @RequestMapping(value = "/goods/getNationalTaxCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsNationalTaxCodeResponse getNationalTaxCode(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsNationalTaxCodeRequest request);


    @ApiOperation(value = "税编结构查询", notes = "", response = MsTaxCodeStructureResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsTaxCodeStructureResponse.class) })
    @RequestMapping(value = "/goods/getTaxCodeStructure",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTaxCodeStructureResponse getTaxCodeStructure( @ApiParam(value = "上级节点税编") @RequestParam(value = "parentTaxCode", required = false) String parentTaxCode);


    @ApiOperation(value = "税编结构末级数据查询", notes = "", response = MsTaxCodeStructureResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回", response = MsTaxCodeStructureResponse.class) })
    @RequestMapping(value = "/goods/getTaxCodeStructureLastStage",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTaxCodeStructureResponse getTaxCodeStructureLastStage( @ApiParam(value = "上级节点税编") @RequestParam(value = "parentTaxCode", required = false) String parentTaxCode);


    @ApiOperation(value = "修改商品字段", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/modifyGoods",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse modifyGoods(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsModifyGoodsRequest request);


    @ApiOperation(value = "批量查询商品", notes = "", response = MsQueryGoodsListResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsQueryGoodsListResponse.class) })
    @RequestMapping(value = "/goods/queryGoodsByNos",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsQueryGoodsListResponse queryGoodsByNos(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsQueryGoodsListRequest request);


    @ApiOperation(value = "查询商品详情", notes = "", response = MsGoodsDetailResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsGoodsDetailResponse.class) })
    @RequestMapping(value = "/goods/queryGoodsDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGoodsDetailResponse queryGoodsDetail(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsDetailRequest request);


    @ApiOperation(value = "修改商品", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/update",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse update(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsUpdateRequest request);


    @ApiOperation(value = "修改品类", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/updateCategory",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse updateCategory(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsCategoryUpdateRequest request);


    @ApiOperation(value = "上传商品", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/upload",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse upload(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsUploadRequest request);


    @ApiOperation(value = "上传商品折扣率", notes = "", response = MsResponse.class, tags={ "Goods", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsResponse.class) })
    @RequestMapping(value = "/goods/uploadDiscount",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse uploadDiscount(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsGoodsDiscountUploadRequest request);

}
