package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsAdvertiseQueryRequest
 */

@JsonInclude(NON_NULL)
public class MsAdvertiseQueryRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("type")
  private Integer type = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("tenantIds")
  private String tenantIds = null;

  @JsonProperty("positon")
  private Integer positon = null;

  @JsonProperty("source")
  private String source = null;

  @JsonProperty("startTime")
  private String startTime = null;

  @JsonProperty("endTime")
  private String endTime = null;

  @JsonProperty("queryType")
  private Integer queryType = null;

  @JsonProperty("taxNum")
  private String taxNum = null;

  @JsonIgnore
  public MsAdvertiseQueryRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(value = "")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 上下线状态：0->下线；1->上线
   * @return status
  **/
  @ApiModelProperty(value = "上下线状态：0->下线；1->上线")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest tenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

   /**
   * 协同购方
   * @return tenantIds
  **/
  @ApiModelProperty(value = "协同购方")
  public String getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(String tenantIds) {
    this.tenantIds = tenantIds;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest positon(Integer positon) {
    this.positon = positon;
    return this;
  }

   /**
   * 广告位置 0登录页背景、1登录页前景 、2入驻页（左）、3入驻页（右）、4登录页（左）、5登录页（右）、6首页（左）、7首页（右）、11首页广告位
   * @return positon
  **/
  @ApiModelProperty(value = "广告位置 0登录页背景、1登录页前景 、2入驻页（左）、3入驻页（右）、4登录页（左）、5登录页（右）、6首页（左）、7首页（右）、11首页广告位")
  public Integer getPositon() {
    return positon;
  }

  public void setPositon(Integer positon) {
    this.positon = positon;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest source(String source) {
    this.source = source;
    return this;
  }

   /**
   * 平台类型 wilmar 益海嘉里
   * @return source
  **/
  @ApiModelProperty(value = "平台类型 wilmar 益海嘉里")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 生效时间
   * @return startTime
  **/
  @ApiModelProperty(value = "生效时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 过期时间
   * @return endTime
  **/
  @ApiModelProperty(value = "过期时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest queryType(Integer queryType) {
    this.queryType = queryType;
    return this;
  }

   /**
   * 查询方式：0->正常；1->随机
   * @return queryType
  **/
  @ApiModelProperty(value = "查询方式：0->正常；1->随机")
  public Integer getQueryType() {
    return queryType;
  }

  public void setQueryType(Integer queryType) {
    this.queryType = queryType;
  }

  @JsonIgnore
  public MsAdvertiseQueryRequest taxNum(String taxNum) {
    this.taxNum = taxNum;
    return this;
  }

   /**
   * 税号
   * @return taxNum
  **/
  @ApiModelProperty(value = "税号")
  public String getTaxNum() {
    return taxNum;
  }

  public void setTaxNum(String taxNum) {
    this.taxNum = taxNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAdvertiseQueryRequest advertiseQueryRequest = (MsAdvertiseQueryRequest) o;
    return Objects.equals(this.id, advertiseQueryRequest.id) &&
        Objects.equals(this.type, advertiseQueryRequest.type) &&
        Objects.equals(this.status, advertiseQueryRequest.status) &&
        Objects.equals(this.tenantIds, advertiseQueryRequest.tenantIds) &&
        Objects.equals(this.positon, advertiseQueryRequest.positon) &&
        Objects.equals(this.source, advertiseQueryRequest.source) &&
        Objects.equals(this.startTime, advertiseQueryRequest.startTime) &&
        Objects.equals(this.endTime, advertiseQueryRequest.endTime) &&
        Objects.equals(this.queryType, advertiseQueryRequest.queryType) &&
        Objects.equals(this.taxNum, advertiseQueryRequest.taxNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, status, tenantIds, positon, source, startTime, endTime, queryType, taxNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAdvertiseQueryRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    positon: ").append(toIndentedString(positon)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    taxNum: ").append(toIndentedString(taxNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
