package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsPaymentStatisticResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 统计年度结算单付款金额
 */
@ApiModel(description = "统计年度结算单付款金额")

@JsonInclude(NON_NULL)
public class MsBillPaymentStatisticResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsPaymentStatisticResult> result = new ArrayList<MsPaymentStatisticResult>();

  @JsonIgnore
  public MsBillPaymentStatisticResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * return code 0:失败 1:成功 2:处理中
   * @return code
  **/
  @ApiModelProperty(value = "return code 0:失败 1:成功 2:处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsBillPaymentStatisticResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsBillPaymentStatisticResponse result(List<MsPaymentStatisticResult> result) {
    this.result = result;
    return this;
  }

  public MsBillPaymentStatisticResponse addResultItem(MsPaymentStatisticResult resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 业务结果
   * @return result
  **/
  @ApiModelProperty(value = "业务结果")
  public List<MsPaymentStatisticResult> getResult() {
    return result;
  }

  public void setResult(List<MsPaymentStatisticResult> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBillPaymentStatisticResponse billPaymentStatisticResponse = (MsBillPaymentStatisticResponse) o;
    return Objects.equals(this.code, billPaymentStatisticResponse.code) &&
        Objects.equals(this.message, billPaymentStatisticResponse.message) &&
        Objects.equals(this.result, billPaymentStatisticResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBillPaymentStatisticResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
