package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCategoryModel
 */

@JsonInclude(NON_NULL)
public class MsCategoryModel {
  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaseTenantId")
  private Long purchaseTenantId = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("categoryDiscountRate")
  private String categoryDiscountRate = null;

  @JsonProperty("channel")
  private String channel = null;

  @JsonIgnore
  public MsCategoryModel sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * Get sellerTenantId
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsCategoryModel purchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
    return this;
  }

   /**
   * Get purchaseTenantId
   * @return purchaseTenantId
  **/
  @ApiModelProperty(value = "")
  public Long getPurchaseTenantId() {
    return purchaseTenantId;
  }

  public void setPurchaseTenantId(Long purchaseTenantId) {
    this.purchaseTenantId = purchaseTenantId;
  }

  @JsonIgnore
  public MsCategoryModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsCategoryModel purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * Get purchaseTaxNo
   * @return purchaseTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public MsCategoryModel sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * Get sellerTaxNo
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsCategoryModel categoryDiscountRate(String categoryDiscountRate) {
    this.categoryDiscountRate = categoryDiscountRate;
    return this;
  }

   /**
   * 折扣率
   * @return categoryDiscountRate
  **/
  @ApiModelProperty(value = "折扣率")
  public String getCategoryDiscountRate() {
    return categoryDiscountRate;
  }

  public void setCategoryDiscountRate(String categoryDiscountRate) {
    this.categoryDiscountRate = categoryDiscountRate;
  }

  @JsonIgnore
  public MsCategoryModel channel(String channel) {
    this.channel = channel;
    return this;
  }

   /**
   * 来源
   * @return channel
  **/
  @ApiModelProperty(value = "来源")
  public String getChannel() {
    return channel;
  }

  public void setChannel(String channel) {
    this.channel = channel;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCategoryModel categoryModel = (MsCategoryModel) o;
    return Objects.equals(this.sellerTenantId, categoryModel.sellerTenantId) &&
        Objects.equals(this.purchaseTenantId, categoryModel.purchaseTenantId) &&
        Objects.equals(this.id, categoryModel.id) &&
        Objects.equals(this.purchaseTaxNo, categoryModel.purchaseTaxNo) &&
        Objects.equals(this.sellerTaxNo, categoryModel.sellerTaxNo) &&
        Objects.equals(this.categoryDiscountRate, categoryModel.categoryDiscountRate) &&
        Objects.equals(this.channel, categoryModel.channel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerTenantId, purchaseTenantId, id, purchaseTaxNo, sellerTaxNo, categoryDiscountRate, channel);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCategoryModel {\n");
    
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaseTenantId: ").append(toIndentedString(purchaseTenantId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    categoryDiscountRate: ").append(toIndentedString(categoryDiscountRate)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
