package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCategoryModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 品类修改
 */
@ApiModel(description = "品类修改")

@JsonInclude(NON_NULL)
public class MsCategoryUpdateRequest {
  @JsonProperty("requestId")
  private String requestId = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("data")
  private List<MsCategoryModel> data = new ArrayList<MsCategoryModel>();

  @JsonIgnore
  public MsCategoryUpdateRequest requestId(String requestId) {
    this.requestId = requestId;
    return this;
  }

   /**
   * uuid
   * @return requestId
  **/
  @ApiModelProperty(value = "uuid")
  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  @JsonIgnore
  public MsCategoryUpdateRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsCategoryUpdateRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsCategoryUpdateRequest data(List<MsCategoryModel> data) {
    this.data = data;
    return this;
  }

  public MsCategoryUpdateRequest addDataItem(MsCategoryModel dataItem) {
    this.data.add(dataItem);
    return this;
  }

   /**
   * Get data
   * @return data
  **/
  @ApiModelProperty(value = "")
  public List<MsCategoryModel> getData() {
    return data;
  }

  public void setData(List<MsCategoryModel> data) {
    this.data = data;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCategoryUpdateRequest categoryUpdateRequest = (MsCategoryUpdateRequest) o;
    return Objects.equals(this.requestId, categoryUpdateRequest.requestId) &&
        Objects.equals(this.opUserId, categoryUpdateRequest.opUserId) &&
        Objects.equals(this.opUserName, categoryUpdateRequest.opUserName) &&
        Objects.equals(this.data, categoryUpdateRequest.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestId, opUserId, opUserName, data);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCategoryUpdateRequest {\n");
    
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
