package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询待办事项
 */
@ApiModel(description = "查询待办事项")

@JsonInclude(NON_NULL)
public class MsClearBacklogRequest {
  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("Id")
  private Long id = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonIgnore
  public MsClearBacklogRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsClearBacklogRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * id
   * @return id
  **/
  @ApiModelProperty(value = "id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsClearBacklogRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsClearBacklogRequest clearBacklogRequest = (MsClearBacklogRequest) o;
    return Objects.equals(this.sellerTenantId, clearBacklogRequest.sellerTenantId) &&
        Objects.equals(this.id, clearBacklogRequest.id) &&
        Objects.equals(this.opUserId, clearBacklogRequest.opUserId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerTenantId, id, opUserId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsClearBacklogRequest {\n");
    
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
