package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 产生CMS的Token的Model
 */
@ApiModel(description = "产生CMS的Token的Model")

@JsonInclude(NON_NULL)
public class MsCmsTokenModel {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("accountId")
  private String accountId = null;

  @JsonProperty("source")
  private String source = null;

  @JsonProperty("ext")
  private String ext = null;

  @JsonIgnore
  public MsCmsTokenModel tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户Id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户Id")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsCmsTokenModel accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * 账户Id
   * @return accountId
  **/
  @ApiModelProperty(value = "账户Id")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  @JsonIgnore
  public MsCmsTokenModel source(String source) {
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @ApiModelProperty(value = "")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsCmsTokenModel ext(String ext) {
    this.ext = ext;
    return this;
  }

   /**
   * 扩展信息
   * @return ext
  **/
  @ApiModelProperty(value = "扩展信息")
  public String getExt() {
    return ext;
  }

  public void setExt(String ext) {
    this.ext = ext;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCmsTokenModel cmsTokenModel = (MsCmsTokenModel) o;
    return Objects.equals(this.tenantId, cmsTokenModel.tenantId) &&
        Objects.equals(this.accountId, cmsTokenModel.accountId) &&
        Objects.equals(this.source, cmsTokenModel.source) &&
        Objects.equals(this.ext, cmsTokenModel.ext);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, accountId, source, ext);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCmsTokenModel {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    ext: ").append(toIndentedString(ext)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
