package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigSysCodeRow
 */

@JsonInclude(NON_NULL)
public class MsConfigSysCodeRow {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("sysId")
  private String sysId = null;

  @JsonProperty("sysCode")
  private String sysCode = null;

  @JsonProperty("sysName")
  private String sysName = null;

  @JsonProperty("seqNum")
  private Integer seqNum = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonIgnore
  public MsConfigSysCodeRow id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键
   * @return id
  **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsConfigSysCodeRow sysId(String sysId) {
    this.sysId = sysId;
    return this;
  }

   /**
   * 代码ID
   * @return sysId
  **/
  @ApiModelProperty(value = "代码ID")
  public String getSysId() {
    return sysId;
  }

  public void setSysId(String sysId) {
    this.sysId = sysId;
  }

  @JsonIgnore
  public MsConfigSysCodeRow sysCode(String sysCode) {
    this.sysCode = sysCode;
    return this;
  }

   /**
   * 代码CODE
   * @return sysCode
  **/
  @ApiModelProperty(value = "代码CODE")
  public String getSysCode() {
    return sysCode;
  }

  public void setSysCode(String sysCode) {
    this.sysCode = sysCode;
  }

  @JsonIgnore
  public MsConfigSysCodeRow sysName(String sysName) {
    this.sysName = sysName;
    return this;
  }

   /**
   * 代码NAME
   * @return sysName
  **/
  @ApiModelProperty(value = "代码NAME")
  public String getSysName() {
    return sysName;
  }

  public void setSysName(String sysName) {
    this.sysName = sysName;
  }

  @JsonIgnore
  public MsConfigSysCodeRow seqNum(Integer seqNum) {
    this.seqNum = seqNum;
    return this;
  }

   /**
   * 序号
   * @return seqNum
  **/
  @ApiModelProperty(value = "序号")
  public Integer getSeqNum() {
    return seqNum;
  }

  public void setSeqNum(Integer seqNum) {
    this.seqNum = seqNum;
  }

  @JsonIgnore
  public MsConfigSysCodeRow remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigSysCodeRow configSysCodeRow = (MsConfigSysCodeRow) o;
    return Objects.equals(this.id, configSysCodeRow.id) &&
        Objects.equals(this.sysId, configSysCodeRow.sysId) &&
        Objects.equals(this.sysCode, configSysCodeRow.sysCode) &&
        Objects.equals(this.sysName, configSysCodeRow.sysName) &&
        Objects.equals(this.seqNum, configSysCodeRow.seqNum) &&
        Objects.equals(this.remark, configSysCodeRow.remark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sysId, sysCode, sysName, seqNum, remark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigSysCodeRow {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    sysId: ").append(toIndentedString(sysId)).append("\n");
    sb.append("    sysCode: ").append(toIndentedString(sysCode)).append("\n");
    sb.append("    sysName: ").append(toIndentedString(sysName)).append("\n");
    sb.append("    seqNum: ").append(toIndentedString(seqNum)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
