package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCoopGoodsAddRequest
 */

@JsonInclude(NON_NULL)
public class MsCoopGoodsAddRequest {
  @JsonProperty("coopGoodsModel")
  private MsCoopGoodsModel coopGoodsModel = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonIgnore
  public MsCoopGoodsAddRequest coopGoodsModel(MsCoopGoodsModel coopGoodsModel) {
    this.coopGoodsModel = coopGoodsModel;
    return this;
  }

   /**
   * 协同商品信息
   * @return coopGoodsModel
  **/
  @ApiModelProperty(value = "协同商品信息")
  public MsCoopGoodsModel getCoopGoodsModel() {
    return coopGoodsModel;
  }

  public void setCoopGoodsModel(MsCoopGoodsModel coopGoodsModel) {
    this.coopGoodsModel = coopGoodsModel;
  }

  @JsonIgnore
  public MsCoopGoodsAddRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsCoopGoodsAddRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 主键
   * @return goodsId
  **/
  @ApiModelProperty(value = "主键")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCoopGoodsAddRequest coopGoodsAddRequest = (MsCoopGoodsAddRequest) o;
    return Objects.equals(this.coopGoodsModel, coopGoodsAddRequest.coopGoodsModel) &&
        Objects.equals(this.tenantId, coopGoodsAddRequest.tenantId) &&
        Objects.equals(this.goodsId, coopGoodsAddRequest.goodsId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coopGoodsModel, tenantId, goodsId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCoopGoodsAddRequest {\n");
    
    sb.append("    coopGoodsModel: ").append(toIndentedString(coopGoodsModel)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
