package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCoopGoodsUpdateRequest
 */

@JsonInclude(NON_NULL)
public class MsCoopGoodsUpdateRequest {
  @JsonProperty("goodsModel")
  private MsCoopGoodsModel goodsModel = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsCoopGoodsUpdateRequest goodsModel(MsCoopGoodsModel goodsModel) {
    this.goodsModel = goodsModel;
    return this;
  }

   /**
   * 商品信息
   * @return goodsModel
  **/
  @ApiModelProperty(value = "商品信息")
  public MsCoopGoodsModel getGoodsModel() {
    return goodsModel;
  }

  public void setGoodsModel(MsCoopGoodsModel goodsModel) {
    this.goodsModel = goodsModel;
  }

  @JsonIgnore
  public MsCoopGoodsUpdateRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCoopGoodsUpdateRequest coopGoodsUpdateRequest = (MsCoopGoodsUpdateRequest) o;
    return Objects.equals(this.goodsModel, coopGoodsUpdateRequest.goodsModel) &&
        Objects.equals(this.tenantId, coopGoodsUpdateRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsModel, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCoopGoodsUpdateRequest {\n");
    
    sb.append("    goodsModel: ").append(toIndentedString(goodsModel)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
