package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCrmProductBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCrmChangeContractProductsRequest
 */

@JsonInclude(NON_NULL)
public class MsCrmChangeContractProductsRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("num")
  private String num = null;

  @JsonProperty("contractProducts")
  private List<MsCrmProductBean> contractProducts = new ArrayList<MsCrmProductBean>();

  @JsonIgnore
  public MsCrmChangeContractProductsRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsCrmChangeContractProductsRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsCrmChangeContractProductsRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsCrmChangeContractProductsRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 使用方税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "使用方税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmChangeContractProductsRequest num(String num) {
    this.num = num;
    return this;
  }

   /**
   * 合同编号
   * @return num
  **/
  @ApiModelProperty(value = "合同编号")
  public String getNum() {
    return num;
  }

  public void setNum(String num) {
    this.num = num;
  }

  @JsonIgnore
  public MsCrmChangeContractProductsRequest contractProducts(List<MsCrmProductBean> contractProducts) {
    this.contractProducts = contractProducts;
    return this;
  }

  public MsCrmChangeContractProductsRequest addContractProductsItem(MsCrmProductBean contractProductsItem) {
    this.contractProducts.add(contractProductsItem);
    return this;
  }

   /**
   * 产品列表
   * @return contractProducts
  **/
  @ApiModelProperty(value = "产品列表")
  public List<MsCrmProductBean> getContractProducts() {
    return contractProducts;
  }

  public void setContractProducts(List<MsCrmProductBean> contractProducts) {
    this.contractProducts = contractProducts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmChangeContractProductsRequest crmChangeContractProductsRequest = (MsCrmChangeContractProductsRequest) o;
    return Objects.equals(this.opUserId, crmChangeContractProductsRequest.opUserId) &&
        Objects.equals(this.opUserName, crmChangeContractProductsRequest.opUserName) &&
        Objects.equals(this.opTenantId, crmChangeContractProductsRequest.opTenantId) &&
        Objects.equals(this.companyTaxNo, crmChangeContractProductsRequest.companyTaxNo) &&
        Objects.equals(this.num, crmChangeContractProductsRequest.num) &&
        Objects.equals(this.contractProducts, crmChangeContractProductsRequest.contractProducts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, companyTaxNo, num, contractProducts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmChangeContractProductsRequest {\n");
    
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    num: ").append(toIndentedString(num)).append("\n");
    sb.append("    contractProducts: ").append(toIndentedString(contractProducts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
