package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCrmProductBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsCrmContractBean
 */

@JsonInclude(NON_NULL)
public class MsCrmContractBean {
  @JsonProperty("contractId")
  private String contractId = null;

  @JsonProperty("batchId")
  private String batchId = null;

  @JsonProperty("num")
  private String num = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("contractSignStartTime")
  private String contractSignStartTime = null;

  @JsonProperty("contractSignEndTime")
  private String contractSignEndTime = null;

  @JsonProperty("startTime")
  private String startTime = null;

  @JsonProperty("endTime")
  private String endTime = null;

  @JsonProperty("money")
  private String money = null;

  @JsonProperty("paymentType")
  private String paymentType = null;

  @JsonProperty("contractOrigin")
  private String contractOrigin = null;

  @JsonProperty("contractStatus")
  private String contractStatus = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("serverCode")
  private String serverCode = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("registerStatus")
  private String registerStatus = null;

  @JsonProperty("registerTime")
  private String registerTime = null;

  @JsonProperty("registerRemark")
  private String registerRemark = null;

  @JsonProperty("feeBillStatus")
  private String feeBillStatus = null;

  @JsonProperty("orderDate")
  private String orderDate = null;

  @JsonProperty("feeBillRemark")
  private String feeBillRemark = null;

  @JsonProperty("feeBillAccount")
  private String feeBillAccount = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("contractProducts")
  private List<MsCrmProductBean> contractProducts = new ArrayList<MsCrmProductBean>();

  @JsonIgnore
  public MsCrmContractBean contractId(String contractId) {
    this.contractId = contractId;
    return this;
  }

   /**
   * 合同主键
   * @return contractId
  **/
  @ApiModelProperty(value = "合同主键")
  public String getContractId() {
    return contractId;
  }

  public void setContractId(String contractId) {
    this.contractId = contractId;
  }

  @JsonIgnore
  public MsCrmContractBean batchId(String batchId) {
    this.batchId = batchId;
    return this;
  }

   /**
   * 合同批次ID
   * @return batchId
  **/
  @ApiModelProperty(value = "合同批次ID")
  public String getBatchId() {
    return batchId;
  }

  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }

  @JsonIgnore
  public MsCrmContractBean num(String num) {
    this.num = num;
    return this;
  }

   /**
   * 合同编号
   * @return num
  **/
  @ApiModelProperty(value = "合同编号")
  public String getNum() {
    return num;
  }

  public void setNum(String num) {
    this.num = num;
  }

  @JsonIgnore
  public MsCrmContractBean name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 合同名称
   * @return name
  **/
  @ApiModelProperty(value = "合同名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsCrmContractBean contractSignStartTime(String contractSignStartTime) {
    this.contractSignStartTime = contractSignStartTime;
    return this;
  }

   /**
   * 合同签约开始时间
   * @return contractSignStartTime
  **/
  @ApiModelProperty(value = "合同签约开始时间")
  public String getContractSignStartTime() {
    return contractSignStartTime;
  }

  public void setContractSignStartTime(String contractSignStartTime) {
    this.contractSignStartTime = contractSignStartTime;
  }

  @JsonIgnore
  public MsCrmContractBean contractSignEndTime(String contractSignEndTime) {
    this.contractSignEndTime = contractSignEndTime;
    return this;
  }

   /**
   * 合同签约结束时间
   * @return contractSignEndTime
  **/
  @ApiModelProperty(value = "合同签约结束时间")
  public String getContractSignEndTime() {
    return contractSignEndTime;
  }

  public void setContractSignEndTime(String contractSignEndTime) {
    this.contractSignEndTime = contractSignEndTime;
  }

  @JsonIgnore
  public MsCrmContractBean startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 合同实际开始时间
   * @return startTime
  **/
  @ApiModelProperty(value = "合同实际开始时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  @JsonIgnore
  public MsCrmContractBean endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 合同实际结束时间
   * @return endTime
  **/
  @ApiModelProperty(value = "合同实际结束时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  @JsonIgnore
  public MsCrmContractBean money(String money) {
    this.money = money;
    return this;
  }

   /**
   * 合同金额
   * @return money
  **/
  @ApiModelProperty(value = "合同金额")
  public String getMoney() {
    return money;
  }

  public void setMoney(String money) {
    this.money = money;
  }

  @JsonIgnore
  public MsCrmContractBean paymentType(String paymentType) {
    this.paymentType = paymentType;
    return this;
  }

   /**
   * 付款方式 TPC-第三方代收
   * @return paymentType
  **/
  @ApiModelProperty(value = "付款方式 TPC-第三方代收")
  public String getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(String paymentType) {
    this.paymentType = paymentType;
  }

  @JsonIgnore
  public MsCrmContractBean contractOrigin(String contractOrigin) {
    this.contractOrigin = contractOrigin;
    return this;
  }

   /**
   * 合同来源 WJ-万家 SG-苏果
   * @return contractOrigin
  **/
  @ApiModelProperty(value = "合同来源 WJ-万家 SG-苏果")
  public String getContractOrigin() {
    return contractOrigin;
  }

  public void setContractOrigin(String contractOrigin) {
    this.contractOrigin = contractOrigin;
  }

  @JsonIgnore
  public MsCrmContractBean contractStatus(String contractStatus) {
    this.contractStatus = contractStatus;
    return this;
  }

   /**
   * 合同状态 0-未生效 1-已生效 2-已终止 3-已失效
   * @return contractStatus
  **/
  @ApiModelProperty(value = "合同状态 0-未生效 1-已生效 2-已终止 3-已失效")
  public String getContractStatus() {
    return contractStatus;
  }

  public void setContractStatus(String contractStatus) {
    this.contractStatus = contractStatus;
  }

  @JsonIgnore
  public MsCrmContractBean remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 合同备注
   * @return remark
  **/
  @ApiModelProperty(value = "合同备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsCrmContractBean serverCode(String serverCode) {
    this.serverCode = serverCode;
    return this;
  }

   /**
   * 服务方代码
   * @return serverCode
  **/
  @ApiModelProperty(value = "服务方代码")
  public String getServerCode() {
    return serverCode;
  }

  public void setServerCode(String serverCode) {
    this.serverCode = serverCode;
  }

  @JsonIgnore
  public MsCrmContractBean companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 使用方税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "使用方税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmContractBean companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 使用方名称
   * @return companyName
  **/
  @ApiModelProperty(value = "使用方名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCrmContractBean registerStatus(String registerStatus) {
    this.registerStatus = registerStatus;
    return this;
  }

   /**
   * 入驻状态 0-未入驻（默认） 1-已入驻 2-入驻中 3-入驻失败
   * @return registerStatus
  **/
  @ApiModelProperty(value = "入驻状态 0-未入驻（默认） 1-已入驻 2-入驻中 3-入驻失败")
  public String getRegisterStatus() {
    return registerStatus;
  }

  public void setRegisterStatus(String registerStatus) {
    this.registerStatus = registerStatus;
  }

  @JsonIgnore
  public MsCrmContractBean registerTime(String registerTime) {
    this.registerTime = registerTime;
    return this;
  }

   /**
   * 入驻时间
   * @return registerTime
  **/
  @ApiModelProperty(value = "入驻时间")
  public String getRegisterTime() {
    return registerTime;
  }

  public void setRegisterTime(String registerTime) {
    this.registerTime = registerTime;
  }

  @JsonIgnore
  public MsCrmContractBean registerRemark(String registerRemark) {
    this.registerRemark = registerRemark;
    return this;
  }

   /**
   * 入驻备注
   * @return registerRemark
  **/
  @ApiModelProperty(value = "入驻备注")
  public String getRegisterRemark() {
    return registerRemark;
  }

  public void setRegisterRemark(String registerRemark) {
    this.registerRemark = registerRemark;
  }

  @JsonIgnore
  public MsCrmContractBean feeBillStatus(String feeBillStatus) {
    this.feeBillStatus = feeBillStatus;
    return this;
  }

   /**
   * 订单生成状态  0-未生成（默认） 1-已生成 2-生成中 3-生成失败
   * @return feeBillStatus
  **/
  @ApiModelProperty(value = "订单生成状态  0-未生成（默认） 1-已生成 2-生成中 3-生成失败")
  public String getFeeBillStatus() {
    return feeBillStatus;
  }

  public void setFeeBillStatus(String feeBillStatus) {
    this.feeBillStatus = feeBillStatus;
  }

  @JsonIgnore
  public MsCrmContractBean orderDate(String orderDate) {
    this.orderDate = orderDate;
    return this;
  }

   /**
   * 订单生成时间
   * @return orderDate
  **/
  @ApiModelProperty(value = "订单生成时间")
  public String getOrderDate() {
    return orderDate;
  }

  public void setOrderDate(String orderDate) {
    this.orderDate = orderDate;
  }

  @JsonIgnore
  public MsCrmContractBean feeBillRemark(String feeBillRemark) {
    this.feeBillRemark = feeBillRemark;
    return this;
  }

   /**
   * 订单生成备注
   * @return feeBillRemark
  **/
  @ApiModelProperty(value = "订单生成备注")
  public String getFeeBillRemark() {
    return feeBillRemark;
  }

  public void setFeeBillRemark(String feeBillRemark) {
    this.feeBillRemark = feeBillRemark;
  }

  @JsonIgnore
  public MsCrmContractBean feeBillAccount(String feeBillAccount) {
    this.feeBillAccount = feeBillAccount;
    return this;
  }

   /**
   * 订单生成账户
   * @return feeBillAccount
  **/
  @ApiModelProperty(value = "订单生成账户")
  public String getFeeBillAccount() {
    return feeBillAccount;
  }

  public void setFeeBillAccount(String feeBillAccount) {
    this.feeBillAccount = feeBillAccount;
  }

  @JsonIgnore
  public MsCrmContractBean createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsCrmContractBean updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsCrmContractBean contractProducts(List<MsCrmProductBean> contractProducts) {
    this.contractProducts = contractProducts;
    return this;
  }

  public MsCrmContractBean addContractProductsItem(MsCrmProductBean contractProductsItem) {
    this.contractProducts.add(contractProductsItem);
    return this;
  }

   /**
   * 产品列表
   * @return contractProducts
  **/
  @ApiModelProperty(value = "产品列表")
  public List<MsCrmProductBean> getContractProducts() {
    return contractProducts;
  }

  public void setContractProducts(List<MsCrmProductBean> contractProducts) {
    this.contractProducts = contractProducts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmContractBean crmContractBean = (MsCrmContractBean) o;
    return Objects.equals(this.contractId, crmContractBean.contractId) &&
        Objects.equals(this.batchId, crmContractBean.batchId) &&
        Objects.equals(this.num, crmContractBean.num) &&
        Objects.equals(this.name, crmContractBean.name) &&
        Objects.equals(this.contractSignStartTime, crmContractBean.contractSignStartTime) &&
        Objects.equals(this.contractSignEndTime, crmContractBean.contractSignEndTime) &&
        Objects.equals(this.startTime, crmContractBean.startTime) &&
        Objects.equals(this.endTime, crmContractBean.endTime) &&
        Objects.equals(this.money, crmContractBean.money) &&
        Objects.equals(this.paymentType, crmContractBean.paymentType) &&
        Objects.equals(this.contractOrigin, crmContractBean.contractOrigin) &&
        Objects.equals(this.contractStatus, crmContractBean.contractStatus) &&
        Objects.equals(this.remark, crmContractBean.remark) &&
        Objects.equals(this.serverCode, crmContractBean.serverCode) &&
        Objects.equals(this.companyTaxNo, crmContractBean.companyTaxNo) &&
        Objects.equals(this.companyName, crmContractBean.companyName) &&
        Objects.equals(this.registerStatus, crmContractBean.registerStatus) &&
        Objects.equals(this.registerTime, crmContractBean.registerTime) &&
        Objects.equals(this.registerRemark, crmContractBean.registerRemark) &&
        Objects.equals(this.feeBillStatus, crmContractBean.feeBillStatus) &&
        Objects.equals(this.orderDate, crmContractBean.orderDate) &&
        Objects.equals(this.feeBillRemark, crmContractBean.feeBillRemark) &&
        Objects.equals(this.feeBillAccount, crmContractBean.feeBillAccount) &&
        Objects.equals(this.createTime, crmContractBean.createTime) &&
        Objects.equals(this.updateTime, crmContractBean.updateTime) &&
        Objects.equals(this.contractProducts, crmContractBean.contractProducts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contractId, batchId, num, name, contractSignStartTime, contractSignEndTime, startTime, endTime, money, paymentType, contractOrigin, contractStatus, remark, serverCode, companyTaxNo, companyName, registerStatus, registerTime, registerRemark, feeBillStatus, orderDate, feeBillRemark, feeBillAccount, createTime, updateTime, contractProducts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmContractBean {\n");
    
    sb.append("    contractId: ").append(toIndentedString(contractId)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    num: ").append(toIndentedString(num)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    contractSignStartTime: ").append(toIndentedString(contractSignStartTime)).append("\n");
    sb.append("    contractSignEndTime: ").append(toIndentedString(contractSignEndTime)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    money: ").append(toIndentedString(money)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("    contractOrigin: ").append(toIndentedString(contractOrigin)).append("\n");
    sb.append("    contractStatus: ").append(toIndentedString(contractStatus)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    serverCode: ").append(toIndentedString(serverCode)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    registerStatus: ").append(toIndentedString(registerStatus)).append("\n");
    sb.append("    registerTime: ").append(toIndentedString(registerTime)).append("\n");
    sb.append("    registerRemark: ").append(toIndentedString(registerRemark)).append("\n");
    sb.append("    feeBillStatus: ").append(toIndentedString(feeBillStatus)).append("\n");
    sb.append("    orderDate: ").append(toIndentedString(orderDate)).append("\n");
    sb.append("    feeBillRemark: ").append(toIndentedString(feeBillRemark)).append("\n");
    sb.append("    feeBillAccount: ").append(toIndentedString(feeBillAccount)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    contractProducts: ").append(toIndentedString(contractProducts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
