package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 供应商信息同步CRM
 */
@ApiModel(description = "供应商信息同步CRM")

@JsonInclude(NON_NULL)
public class MsCrmSyncCmpInfoRequest {
  @JsonProperty("purchaserTenantCode")
  private String purchaserTenantCode = null;

  @JsonProperty("companyNo")
  private String companyNo = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyAddr")
  private String companyAddr = null;

  @JsonProperty("companyTel")
  private String companyTel = null;

  @JsonProperty("taxpayerType")
  private String taxpayerType = null;

  @JsonProperty("contactorName")
  private String contactorName = null;

  @JsonProperty("contactorEmail")
  private String contactorEmail = null;

  @JsonProperty("contactorMobile")
  private String contactorMobile = null;

  @JsonProperty("contactorTel")
  private String contactorTel = null;

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest purchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
    return this;
  }

   /**
   * 购方租户代码  wilmar-益海嘉里
   * @return purchaserTenantCode
  **/
  @ApiModelProperty(value = "购方租户代码  wilmar-益海嘉里")
  public String getPurchaserTenantCode() {
    return purchaserTenantCode;
  }

  public void setPurchaserTenantCode(String purchaserTenantCode) {
    this.purchaserTenantCode = purchaserTenantCode;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest companyNo(String companyNo) {
    this.companyNo = companyNo;
    return this;
  }

   /**
   * 公司编号 多个逗号隔开
   * @return companyNo
  **/
  @ApiModelProperty(value = "公司编号 多个逗号隔开")
  public String getCompanyNo() {
    return companyNo;
  }

  public void setCompanyNo(String companyNo) {
    this.companyNo = companyNo;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest companyAddr(String companyAddr) {
    this.companyAddr = companyAddr;
    return this;
  }

   /**
   * 公司地址
   * @return companyAddr
  **/
  @ApiModelProperty(value = "公司地址")
  public String getCompanyAddr() {
    return companyAddr;
  }

  public void setCompanyAddr(String companyAddr) {
    this.companyAddr = companyAddr;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest companyTel(String companyTel) {
    this.companyTel = companyTel;
    return this;
  }

   /**
   * 公司电话
   * @return companyTel
  **/
  @ApiModelProperty(value = "公司电话")
  public String getCompanyTel() {
    return companyTel;
  }

  public void setCompanyTel(String companyTel) {
    this.companyTel = companyTel;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest taxpayerType(String taxpayerType) {
    this.taxpayerType = taxpayerType;
    return this;
  }

   /**
   * 纳税人类型：0-小规模纳税人 1-一般纳税人
   * @return taxpayerType
  **/
  @ApiModelProperty(value = "纳税人类型：0-小规模纳税人 1-一般纳税人")
  public String getTaxpayerType() {
    return taxpayerType;
  }

  public void setTaxpayerType(String taxpayerType) {
    this.taxpayerType = taxpayerType;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest contactorName(String contactorName) {
    this.contactorName = contactorName;
    return this;
  }

   /**
   * 联系人姓名
   * @return contactorName
  **/
  @ApiModelProperty(value = "联系人姓名")
  public String getContactorName() {
    return contactorName;
  }

  public void setContactorName(String contactorName) {
    this.contactorName = contactorName;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest contactorEmail(String contactorEmail) {
    this.contactorEmail = contactorEmail;
    return this;
  }

   /**
   * 联系人邮箱
   * @return contactorEmail
  **/
  @ApiModelProperty(value = "联系人邮箱")
  public String getContactorEmail() {
    return contactorEmail;
  }

  public void setContactorEmail(String contactorEmail) {
    this.contactorEmail = contactorEmail;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest contactorMobile(String contactorMobile) {
    this.contactorMobile = contactorMobile;
    return this;
  }

   /**
   * 联系人手机号
   * @return contactorMobile
  **/
  @ApiModelProperty(value = "联系人手机号")
  public String getContactorMobile() {
    return contactorMobile;
  }

  public void setContactorMobile(String contactorMobile) {
    this.contactorMobile = contactorMobile;
  }

  @JsonIgnore
  public MsCrmSyncCmpInfoRequest contactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
    return this;
  }

   /**
   * 联系人电话
   * @return contactorTel
  **/
  @ApiModelProperty(value = "联系人电话")
  public String getContactorTel() {
    return contactorTel;
  }

  public void setContactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCrmSyncCmpInfoRequest crmSyncCmpInfoRequest = (MsCrmSyncCmpInfoRequest) o;
    return Objects.equals(this.purchaserTenantCode, crmSyncCmpInfoRequest.purchaserTenantCode) &&
        Objects.equals(this.companyNo, crmSyncCmpInfoRequest.companyNo) &&
        Objects.equals(this.companyTaxNo, crmSyncCmpInfoRequest.companyTaxNo) &&
        Objects.equals(this.companyName, crmSyncCmpInfoRequest.companyName) &&
        Objects.equals(this.companyAddr, crmSyncCmpInfoRequest.companyAddr) &&
        Objects.equals(this.companyTel, crmSyncCmpInfoRequest.companyTel) &&
        Objects.equals(this.taxpayerType, crmSyncCmpInfoRequest.taxpayerType) &&
        Objects.equals(this.contactorName, crmSyncCmpInfoRequest.contactorName) &&
        Objects.equals(this.contactorEmail, crmSyncCmpInfoRequest.contactorEmail) &&
        Objects.equals(this.contactorMobile, crmSyncCmpInfoRequest.contactorMobile) &&
        Objects.equals(this.contactorTel, crmSyncCmpInfoRequest.contactorTel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserTenantCode, companyNo, companyTaxNo, companyName, companyAddr, companyTel, taxpayerType, contactorName, contactorEmail, contactorMobile, contactorTel);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCrmSyncCmpInfoRequest {\n");
    
    sb.append("    purchaserTenantCode: ").append(toIndentedString(purchaserTenantCode)).append("\n");
    sb.append("    companyNo: ").append(toIndentedString(companyNo)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyAddr: ").append(toIndentedString(companyAddr)).append("\n");
    sb.append("    companyTel: ").append(toIndentedString(companyTel)).append("\n");
    sb.append("    taxpayerType: ").append(toIndentedString(taxpayerType)).append("\n");
    sb.append("    contactorName: ").append(toIndentedString(contactorName)).append("\n");
    sb.append("    contactorEmail: ").append(toIndentedString(contactorEmail)).append("\n");
    sb.append("    contactorMobile: ").append(toIndentedString(contactorMobile)).append("\n");
    sb.append("    contactorTel: ").append(toIndentedString(contactorTel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
