package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsDeleteRequest
 */

@JsonInclude(NON_NULL)
public class MsGoodsDeleteRequest {
  @JsonProperty("goodsId")
  private Long goodsId = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonIgnore
  public MsGoodsDeleteRequest goodsId(Long goodsId) {
    this.goodsId = goodsId;
    return this;
  }

   /**
   * 主键
   * @return goodsId
  **/
  @ApiModelProperty(value = "主键")
  public Long getGoodsId() {
    return goodsId;
  }

  public void setGoodsId(Long goodsId) {
    this.goodsId = goodsId;
  }

  @JsonIgnore
  public MsGoodsDeleteRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsDeleteRequest goodsDeleteRequest = (MsGoodsDeleteRequest) o;
    return Objects.equals(this.goodsId, goodsDeleteRequest.goodsId) &&
        Objects.equals(this.tenantId, goodsDeleteRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(goodsId, tenantId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsDeleteRequest {\n");
    
    sb.append("    goodsId: ").append(toIndentedString(goodsId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
