package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTowerImportFileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品上传请求
 */
@ApiModel(description = "商品上传请求")

@JsonInclude(NON_NULL)
public class MsGoodsDiscountUploadRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("files")
  private List<MsTowerImportFileInfo> files = new ArrayList<MsTowerImportFileInfo>();

  @JsonIgnore
  public MsGoodsDiscountUploadRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsGoodsDiscountUploadRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsGoodsDiscountUploadRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户ID
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户ID")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsGoodsDiscountUploadRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户ID
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户ID")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsGoodsDiscountUploadRequest files(List<MsTowerImportFileInfo> files) {
    this.files = files;
    return this;
  }

  public MsGoodsDiscountUploadRequest addFilesItem(MsTowerImportFileInfo filesItem) {
    this.files.add(filesItem);
    return this;
  }

   /**
   * 上传文件信息
   * @return files
  **/
  @ApiModelProperty(value = "上传文件信息")
  public List<MsTowerImportFileInfo> getFiles() {
    return files;
  }

  public void setFiles(List<MsTowerImportFileInfo> files) {
    this.files = files;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsDiscountUploadRequest goodsDiscountUploadRequest = (MsGoodsDiscountUploadRequest) o;
    return Objects.equals(this.opUserId, goodsDiscountUploadRequest.opUserId) &&
        Objects.equals(this.opUserName, goodsDiscountUploadRequest.opUserName) &&
        Objects.equals(this.sellerTenantId, goodsDiscountUploadRequest.sellerTenantId) &&
        Objects.equals(this.purchaserTenantId, goodsDiscountUploadRequest.purchaserTenantId) &&
        Objects.equals(this.files, goodsDiscountUploadRequest.files);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, sellerTenantId, purchaserTenantId, files);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsDiscountUploadRequest {\n");
    
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
