package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsCoopGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGoodsPageModel
 */

@JsonInclude(NON_NULL)
public class MsGoodsPageModel {
  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("goodItems")
  private List<MsGoodsModel> goodItems = new ArrayList<MsGoodsModel>();

  @JsonIgnore
  public MsGoodsPageModel total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 数量
   * @return total
  **/
  @ApiModelProperty(value = "数量")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGoodsPageModel pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页码大小
   * @return pageSize
  **/
  @ApiModelProperty(value = "页码大小")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsGoodsPageModel pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码数
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码数")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGoodsPageModel result(List<MsGoodsModel> result) {
    this.goodItems = result;
    return this;
  }

  public MsGoodsPageModel addResultItem(MsGoodsModel resultItem) {
    this.goodItems.add(resultItem);
    return this;
  }

   /**
   * 商品数组
   * @return result
  **/
  @ApiModelProperty(value = "商品数组")
  public List<MsGoodsModel> getResult() {
    return goodItems;
  }

  public void setResult(List<MsGoodsModel> result) {
    this.goodItems = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsPageModel goodsPageModel = (MsGoodsPageModel) o;
    return Objects.equals(this.total, goodsPageModel.total) &&
        Objects.equals(this.pageSize, goodsPageModel.pageSize) &&
        Objects.equals(this.pageNo, goodsPageModel.pageNo) &&
        Objects.equals(this.goodItems, goodsPageModel.goodItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, pageSize, pageNo, goodItems);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsPageModel {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    result: ").append(toIndentedString(goodItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
