package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsTowerImportFileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 商品上传请求
 */
@ApiModel(description = "商品上传请求")

@JsonInclude(NON_NULL)
public class MsGoodsUploadRequest {
  @JsonProperty("isCover")
  private Integer isCover = null;

  @JsonProperty("isRefresh")
  private Integer isRefresh = null;

  @JsonProperty("isSyncGoodsNo")
  private Integer isSyncGoodsNo = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("purchaserTenantName")
  private String purchaserTenantName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("files")
  private List<MsTowerImportFileInfo> files = new ArrayList<MsTowerImportFileInfo>();

  @JsonIgnore
  public MsGoodsUploadRequest isCover(Integer isCover) {
    this.isCover = isCover;
    return this;
  }

   /**
   * 自有商品重复时是否覆盖 1-覆盖 0-不覆盖
   * @return isCover
  **/
  @ApiModelProperty(value = "自有商品重复时是否覆盖 1-覆盖 0-不覆盖")
  public Integer getIsCover() {
    return isCover;
  }

  public void setIsCover(Integer isCover) {
    this.isCover = isCover;
  }

  @JsonIgnore
  public MsGoodsUploadRequest isRefresh(Integer isRefresh) {
    this.isRefresh = isRefresh;
    return this;
  }

   /**
   * 协同商品是否刷新结算单 1-刷新 0-不刷新
   * @return isRefresh
  **/
  @ApiModelProperty(value = "协同商品是否刷新结算单 1-刷新 0-不刷新")
  public Integer getIsRefresh() {
    return isRefresh;
  }

  public void setIsRefresh(Integer isRefresh) {
    this.isRefresh = isRefresh;
  }

  @JsonIgnore
  public MsGoodsUploadRequest isSyncGoodsNo(Integer isSyncGoodsNo) {
    this.isSyncGoodsNo = isSyncGoodsNo;
    return this;
  }

   /**
   * 商品编码是否同步到协同购方商品编码 1-同步 0-不同步
   * @return isSyncGoodsNo
  **/
  @ApiModelProperty(value = "商品编码是否同步到协同购方商品编码 1-同步 0-不同步")
  public Integer getIsSyncGoodsNo() {
    return isSyncGoodsNo;
  }

  public void setIsSyncGoodsNo(Integer isSyncGoodsNo) {
    this.isSyncGoodsNo = isSyncGoodsNo;
  }

  @JsonIgnore
  public MsGoodsUploadRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsGoodsUploadRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsGoodsUploadRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户ID
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户ID")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsGoodsUploadRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户ID
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户ID")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsGoodsUploadRequest purchaserTenantName(String purchaserTenantName) {
    this.purchaserTenantName = purchaserTenantName;
    return this;
  }

   /**
   * 购方租户名
   * @return purchaserTenantName
  **/
  @ApiModelProperty(value = "购方租户名")
  public String getPurchaserTenantName() {
    return purchaserTenantName;
  }

  public void setPurchaserTenantName(String purchaserTenantName) {
    this.purchaserTenantName = purchaserTenantName;
  }

  @JsonIgnore
  public MsGoodsUploadRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 购方租户名
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "购方租户名")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsGoodsUploadRequest files(List<MsTowerImportFileInfo> files) {
    this.files = files;
    return this;
  }

  public MsGoodsUploadRequest addFilesItem(MsTowerImportFileInfo filesItem) {
    this.files.add(filesItem);
    return this;
  }

   /**
   * 上传文件信息
   * @return files
  **/
  @ApiModelProperty(value = "上传文件信息")
  public List<MsTowerImportFileInfo> getFiles() {
    return files;
  }

  public void setFiles(List<MsTowerImportFileInfo> files) {
    this.files = files;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGoodsUploadRequest goodsUploadRequest = (MsGoodsUploadRequest) o;
    return Objects.equals(this.isCover, goodsUploadRequest.isCover) &&
        Objects.equals(this.isRefresh, goodsUploadRequest.isRefresh) &&
        Objects.equals(this.isSyncGoodsNo, goodsUploadRequest.isSyncGoodsNo) &&
        Objects.equals(this.opUserId, goodsUploadRequest.opUserId) &&
        Objects.equals(this.opUserName, goodsUploadRequest.opUserName) &&
        Objects.equals(this.sellerTenantId, goodsUploadRequest.sellerTenantId) &&
        Objects.equals(this.purchaserTenantId, goodsUploadRequest.purchaserTenantId) &&
        Objects.equals(this.purchaserTenantName, goodsUploadRequest.purchaserTenantName) &&
        Objects.equals(this.companyTaxNo, goodsUploadRequest.companyTaxNo) &&
        Objects.equals(this.files, goodsUploadRequest.files);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isCover, isRefresh, isSyncGoodsNo, opUserId, opUserName, sellerTenantId, purchaserTenantId, purchaserTenantName, companyTaxNo, files);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGoodsUploadRequest {\n");
    
    sb.append("    isCover: ").append(toIndentedString(isCover)).append("\n");
    sb.append("    isRefresh: ").append(toIndentedString(isRefresh)).append("\n");
    sb.append("    isSyncGoodsNo: ").append(toIndentedString(isSyncGoodsNo)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    purchaserTenantName: ").append(toIndentedString(purchaserTenantName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
