package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 短链接创建请求参数
 */
@ApiModel(description = "短链接创建请求参数")

@JsonInclude(NON_NULL)
public class MsLinkCreateRequest {
  @JsonProperty("link")
  private String link = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("expireTime")
  private Integer expireTime = null;

  @JsonIgnore
  public MsLinkCreateRequest link(String link) {
    this.link = link;
    return this;
  }

   /**
   * 原链接
   * @return link
  **/
  @ApiModelProperty(value = "原链接")
  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  @JsonIgnore
  public MsLinkCreateRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态 0-永久 1-临时
   * @return status
  **/
  @ApiModelProperty(value = "状态 0-永久 1-临时")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsLinkCreateRequest expireTime(Integer expireTime) {
    this.expireTime = expireTime;
    return this;
  }

   /**
   * 临时状态时设置 默认30(单位:MIN)
   * @return expireTime
  **/
  @ApiModelProperty(value = "临时状态时设置 默认30(单位:MIN)")
  public Integer getExpireTime() {
    return expireTime;
  }

  public void setExpireTime(Integer expireTime) {
    this.expireTime = expireTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsLinkCreateRequest linkCreateRequest = (MsLinkCreateRequest) o;
    return Objects.equals(this.link, linkCreateRequest.link) &&
        Objects.equals(this.status, linkCreateRequest.status) &&
        Objects.equals(this.expireTime, linkCreateRequest.expireTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(link, status, expireTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsLinkCreateRequest {\n");
    
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    expireTime: ").append(toIndentedString(expireTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
