package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsMenuModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 菜单MODEL
 */
@ApiModel(description = "菜单MODEL")

@JsonInclude(NON_NULL)
public class MsMenuModel {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("pid")
  private Long pid = null;

  @JsonProperty("menuName")
  private String menuName = null;

  @JsonProperty("productionLine")
  private String productionLine = null;

  @JsonProperty("level")
  private Integer level = null;

  @JsonProperty("sort_index")
  private Integer sortIndex = null;

  @JsonProperty("hasSubMenu")
  private Boolean hasSubMenu = null;

  @JsonProperty("hasSupportMsg")
  private Boolean hasSupportMsg = null;

  @JsonProperty("subModels")
  private List<MsMenuModel> subModels = new ArrayList<MsMenuModel>();

  @JsonIgnore
  public MsMenuModel id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * id
   * @return id
  **/
  @ApiModelProperty(value = "id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsMenuModel pid(Long pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 父id
   * @return pid
  **/
  @ApiModelProperty(value = "父id")
  public Long getPid() {
    return pid;
  }

  public void setPid(Long pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public MsMenuModel menuName(String menuName) {
    this.menuName = menuName;
    return this;
  }

   /**
   * Get menuName
   * @return menuName
  **/
  @ApiModelProperty(value = "")
  public String getMenuName() {
    return menuName;
  }

  public void setMenuName(String menuName) {
    this.menuName = menuName;
  }

  @JsonIgnore
  public MsMenuModel productionLine(String productionLine) {
    this.productionLine = productionLine;
    return this;
  }

   /**
   * 产线
   * @return productionLine
  **/
  @ApiModelProperty(value = "产线")
  public String getProductionLine() {
    return productionLine;
  }

  public void setProductionLine(String productionLine) {
    this.productionLine = productionLine;
  }

  @JsonIgnore
  public MsMenuModel level(Integer level) {
    this.level = level;
    return this;
  }

   /**
   * 所处level
   * @return level
  **/
  @ApiModelProperty(value = "所处level")
  public Integer getLevel() {
    return level;
  }

  public void setLevel(Integer level) {
    this.level = level;
  }

  @JsonIgnore
  public MsMenuModel sortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
    return this;
  }

   /**
   * 排序
   * @return sortIndex
  **/
  @ApiModelProperty(value = "排序")
  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  @JsonIgnore
  public MsMenuModel hasSubMenu(Boolean hasSubMenu) {
    this.hasSubMenu = hasSubMenu;
    return this;
  }

   /**
   * 是否有子级菜单
   * @return hasSubMenu
  **/
  @ApiModelProperty(value = "是否有子级菜单")
  public Boolean getHasSubMenu() {
    return hasSubMenu;
  }

  public void setHasSubMenu(Boolean hasSubMenu) {
    this.hasSubMenu = hasSubMenu;
  }

  @JsonIgnore
  public MsMenuModel hasSupportMsg(Boolean hasSupportMsg) {
    this.hasSupportMsg = hasSupportMsg;
    return this;
  }

   /**
   * 是否有帮助消息
   * @return hasSupportMsg
  **/
  @ApiModelProperty(value = "是否有帮助消息")
  public Boolean getHasSupportMsg() {
    return hasSupportMsg;
  }

  public void setHasSupportMsg(Boolean hasSupportMsg) {
    this.hasSupportMsg = hasSupportMsg;
  }

  @JsonIgnore
  public MsMenuModel subModels(List<MsMenuModel> subModels) {
    this.subModels = subModels;
    return this;
  }

  public MsMenuModel addSubModelsItem(MsMenuModel subModelsItem) {
    this.subModels.add(subModelsItem);
    return this;
  }

   /**
   * 子级菜单
   * @return subModels
  **/
  @ApiModelProperty(value = "子级菜单")
  public List<MsMenuModel> getSubModels() {
    return subModels;
  }

  public void setSubModels(List<MsMenuModel> subModels) {
    this.subModels = subModels;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMenuModel menuModel = (MsMenuModel) o;
    return Objects.equals(this.id, menuModel.id) &&
        Objects.equals(this.pid, menuModel.pid) &&
        Objects.equals(this.menuName, menuModel.menuName) &&
        Objects.equals(this.productionLine, menuModel.productionLine) &&
        Objects.equals(this.level, menuModel.level) &&
        Objects.equals(this.sortIndex, menuModel.sortIndex) &&
        Objects.equals(this.hasSubMenu, menuModel.hasSubMenu) &&
        Objects.equals(this.hasSupportMsg, menuModel.hasSupportMsg) &&
        Objects.equals(this.subModels, menuModel.subModels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, pid, menuName, productionLine, level, sortIndex, hasSubMenu, hasSupportMsg, subModels);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMenuModel {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    menuName: ").append(toIndentedString(menuName)).append("\n");
    sb.append("    productionLine: ").append(toIndentedString(productionLine)).append("\n");
    sb.append("    level: ").append(toIndentedString(level)).append("\n");
    sb.append("    sortIndex: ").append(toIndentedString(sortIndex)).append("\n");
    sb.append("    hasSubMenu: ").append(toIndentedString(hasSubMenu)).append("\n");
    sb.append("    hasSupportMsg: ").append(toIndentedString(hasSupportMsg)).append("\n");
    sb.append("    subModels: ").append(toIndentedString(subModels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
