package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.system.client.model.MsModifyGoodsModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsModifyGoodsRequest
 */

@JsonInclude(NON_NULL)
public class MsModifyGoodsRequest {
  @JsonProperty("operatorType")
  private String operatorType = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("sellerCompanyId")
  private Long sellerCompanyId = null;

  @JsonProperty("requestId")
  private String requestId = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerCompanyName")
  private String sellerCompanyName = null;

  @JsonProperty("submitTenantId")
  private Long submitTenantId = null;

  @JsonProperty("submitUserId")
  private Long submitUserId = null;

  @JsonProperty("submitUserName")
  private String submitUserName = null;

  @JsonProperty("submitTime")
  private String submitTime = null;

  @JsonProperty("data")
  private List<MsModifyGoodsModel> data = new ArrayList<MsModifyGoodsModel>();

  @JsonIgnore
  public MsModifyGoodsRequest operatorType(String operatorType) {
    this.operatorType = operatorType;
    return this;
  }

   /**
   * 操作类型 DR-goodsDiscountRate UO-unitModelOnly NT-nameAndTaxCode  IM-itemModify
   * @return operatorType
  **/
  @ApiModelProperty(value = "操作类型 DR-goodsDiscountRate UO-unitModelOnly NT-nameAndTaxCode  IM-itemModify")
  public String getOperatorType() {
    return operatorType;
  }

  public void setOperatorType(String operatorType) {
    this.operatorType = operatorType;
  }

  @JsonIgnore
  public MsModifyGoodsRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsModifyGoodsRequest sellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
    return this;
  }

   /**
   * Get sellerCompanyId
   * @return sellerCompanyId
  **/
  @ApiModelProperty(value = "")
  public Long getSellerCompanyId() {
    return sellerCompanyId;
  }

  public void setSellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
  }

  @JsonIgnore
  public MsModifyGoodsRequest requestId(String requestId) {
    this.requestId = requestId;
    return this;
  }

   /**
   * Get requestId
   * @return requestId
  **/
  @ApiModelProperty(value = "")
  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  @JsonIgnore
  public MsModifyGoodsRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * Get sellerTaxNo
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsModifyGoodsRequest sellerCompanyName(String sellerCompanyName) {
    this.sellerCompanyName = sellerCompanyName;
    return this;
  }

   /**
   * 销方企业名称
   * @return sellerCompanyName
  **/
  @ApiModelProperty(value = "销方企业名称")
  public String getSellerCompanyName() {
    return sellerCompanyName;
  }

  public void setSellerCompanyName(String sellerCompanyName) {
    this.sellerCompanyName = sellerCompanyName;
  }

  @JsonIgnore
  public MsModifyGoodsRequest submitTenantId(Long submitTenantId) {
    this.submitTenantId = submitTenantId;
    return this;
  }

   /**
   * 提交租户id
   * @return submitTenantId
  **/
  @ApiModelProperty(value = "提交租户id")
  public Long getSubmitTenantId() {
    return submitTenantId;
  }

  public void setSubmitTenantId(Long submitTenantId) {
    this.submitTenantId = submitTenantId;
  }

  @JsonIgnore
  public MsModifyGoodsRequest submitUserId(Long submitUserId) {
    this.submitUserId = submitUserId;
    return this;
  }

   /**
   * 提交用户id
   * @return submitUserId
  **/
  @ApiModelProperty(value = "提交用户id")
  public Long getSubmitUserId() {
    return submitUserId;
  }

  public void setSubmitUserId(Long submitUserId) {
    this.submitUserId = submitUserId;
  }

  @JsonIgnore
  public MsModifyGoodsRequest submitUserName(String submitUserName) {
    this.submitUserName = submitUserName;
    return this;
  }

   /**
   * Get submitUserName
   * @return submitUserName
  **/
  @ApiModelProperty(value = "")
  public String getSubmitUserName() {
    return submitUserName;
  }

  public void setSubmitUserName(String submitUserName) {
    this.submitUserName = submitUserName;
  }

  @JsonIgnore
  public MsModifyGoodsRequest submitTime(String submitTime) {
    this.submitTime = submitTime;
    return this;
  }

   /**
   * 提交时间 yyyy-MM-dd HH:mm:ss
   * @return submitTime
  **/
  @ApiModelProperty(value = "提交时间 yyyy-MM-dd HH:mm:ss")
  public String getSubmitTime() {
    return submitTime;
  }

  public void setSubmitTime(String submitTime) {
    this.submitTime = submitTime;
  }

  @JsonIgnore
  public MsModifyGoodsRequest data(List<MsModifyGoodsModel> data) {
    this.data = data;
    return this;
  }

  public MsModifyGoodsRequest addDataItem(MsModifyGoodsModel dataItem) {
    this.data.add(dataItem);
    return this;
  }

   /**
   * Get data
   * @return data
  **/
  @ApiModelProperty(value = "")
  public List<MsModifyGoodsModel> getData() {
    return data;
  }

  public void setData(List<MsModifyGoodsModel> data) {
    this.data = data;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsModifyGoodsRequest modifyGoodsRequest = (MsModifyGoodsRequest) o;
    return Objects.equals(this.operatorType, modifyGoodsRequest.operatorType) &&
        Objects.equals(this.sellerTenantId, modifyGoodsRequest.sellerTenantId) &&
        Objects.equals(this.sellerCompanyId, modifyGoodsRequest.sellerCompanyId) &&
        Objects.equals(this.requestId, modifyGoodsRequest.requestId) &&
        Objects.equals(this.sellerTaxNo, modifyGoodsRequest.sellerTaxNo) &&
        Objects.equals(this.sellerCompanyName, modifyGoodsRequest.sellerCompanyName) &&
        Objects.equals(this.submitTenantId, modifyGoodsRequest.submitTenantId) &&
        Objects.equals(this.submitUserId, modifyGoodsRequest.submitUserId) &&
        Objects.equals(this.submitUserName, modifyGoodsRequest.submitUserName) &&
        Objects.equals(this.submitTime, modifyGoodsRequest.submitTime) &&
        Objects.equals(this.data, modifyGoodsRequest.data);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operatorType, sellerTenantId, sellerCompanyId, requestId, sellerTaxNo, sellerCompanyName, submitTenantId, submitUserId, submitUserName, submitTime, data);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsModifyGoodsRequest {\n");
    
    sb.append("    operatorType: ").append(toIndentedString(operatorType)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    sellerCompanyId: ").append(toIndentedString(sellerCompanyId)).append("\n");
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerCompanyName: ").append(toIndentedString(sellerCompanyName)).append("\n");
    sb.append("    submitTenantId: ").append(toIndentedString(submitTenantId)).append("\n");
    sb.append("    submitUserId: ").append(toIndentedString(submitUserId)).append("\n");
    sb.append("    submitUserName: ").append(toIndentedString(submitUserName)).append("\n");
    sb.append("    submitTime: ").append(toIndentedString(submitTime)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
