package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsOpHomepageVerRequest
 */

@JsonInclude(NON_NULL)
public class MsOpHomepageVerRequest {
  @JsonProperty("opType")
  private Integer opType = null;

  @JsonProperty("version")
  private Integer version = null;

  @JsonProperty("userIdLists")
  private List<Long> userIdLists = new ArrayList<Long>();

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsOpHomepageVerRequest opType(Integer opType) {
    this.opType = opType;
    return this;
  }

   /**
   * 操作类型 1-新增 2-更新 3-删除
   * @return opType
  **/
  @ApiModelProperty(value = "操作类型 1-新增 2-更新 3-删除")
  public Integer getOpType() {
    return opType;
  }

  public void setOpType(Integer opType) {
    this.opType = opType;
  }

  @JsonIgnore
  public MsOpHomepageVerRequest version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * 首页版本 0-旧 1-新
   * @return version
  **/
  @ApiModelProperty(value = "首页版本 0-旧 1-新")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  @JsonIgnore
  public MsOpHomepageVerRequest userIdLists(List<Long> userIdLists) {
    this.userIdLists = userIdLists;
    return this;
  }

  public MsOpHomepageVerRequest addUserIdListsItem(Long userIdListsItem) {
    this.userIdLists.add(userIdListsItem);
    return this;
  }

   /**
   * 用户id集合
   * @return userIdLists
  **/
  @ApiModelProperty(value = "用户id集合")
  public List<Long> getUserIdLists() {
    return userIdLists;
  }

  public void setUserIdLists(List<Long> userIdLists) {
    this.userIdLists = userIdLists;
  }

  @JsonIgnore
  public MsOpHomepageVerRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作用户id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作用户id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsOpHomepageVerRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作用户名称
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作用户名称")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsOpHomepageVerRequest opHomepageVerRequest = (MsOpHomepageVerRequest) o;
    return Objects.equals(this.opType, opHomepageVerRequest.opType) &&
        Objects.equals(this.version, opHomepageVerRequest.version) &&
        Objects.equals(this.userIdLists, opHomepageVerRequest.userIdLists) &&
        Objects.equals(this.opUserId, opHomepageVerRequest.opUserId) &&
        Objects.equals(this.opUserName, opHomepageVerRequest.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opType, version, userIdLists, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsOpHomepageVerRequest {\n");
    
    sb.append("    opType: ").append(toIndentedString(opType)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    userIdLists: ").append(toIndentedString(userIdLists)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
