package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 优惠政策分组列表
 */
@ApiModel(description = "优惠政策分组列表")

@JsonInclude(NON_NULL)
public class MsPolicyGroup {
  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPolicy")
  private String taxPolicy = null;

  @JsonProperty("preferentialTax")
  private Boolean preferentialTax = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public MsPolicyGroup taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率 为 0.xx/0.xxx  形式
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率 为 0.xx/0.xxx  形式")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsPolicyGroup taxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
    return this;
  }

   /**
   * 优惠政策
   * @return taxPolicy
  **/
  @ApiModelProperty(value = "优惠政策")
  public String getTaxPolicy() {
    return taxPolicy;
  }

  public void setTaxPolicy(String taxPolicy) {
    this.taxPolicy = taxPolicy;
  }

  @JsonIgnore
  public MsPolicyGroup preferentialTax(Boolean preferentialTax) {
    this.preferentialTax = preferentialTax;
    return this;
  }

   /**
   * 是否享受优惠政策 true是 false 否
   * @return preferentialTax
  **/
  @ApiModelProperty(value = "是否享受优惠政策 true是 false 否")
  public Boolean getPreferentialTax() {
    return preferentialTax;
  }

  public void setPreferentialTax(Boolean preferentialTax) {
    this.preferentialTax = preferentialTax;
  }

  @JsonIgnore
  public MsPolicyGroup zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识： 1 免税 ；2 不征税 ；3 普通0税率 ；0 出口退税
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标识： 1 免税 ；2 不征税 ；3 普通0税率 ；0 出口退税")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsPolicyGroup policyGroup = (MsPolicyGroup) o;
    return Objects.equals(this.taxRate, policyGroup.taxRate) &&
        Objects.equals(this.taxPolicy, policyGroup.taxPolicy) &&
        Objects.equals(this.preferentialTax, policyGroup.preferentialTax) &&
        Objects.equals(this.zeroTax, policyGroup.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxRate, taxPolicy, preferentialTax, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsPolicyGroup {\n");
    
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPolicy: ").append(toIndentedString(taxPolicy)).append("\n");
    sb.append("    preferentialTax: ").append(toIndentedString(preferentialTax)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
