package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 查询待办事项
 */
@ApiModel(description = "查询待办事项")

@JsonInclude(NON_NULL)
public class MsQueryBacklogRequest {
  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("businessType")
  private String businessType = null;

  @JsonIgnore
  public MsQueryBacklogRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 页面展示数据数量
   * @return pageSize
  **/
  @ApiModelProperty(value = "页面展示数据数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsQueryBacklogRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页面当前页数
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页面当前页数")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsQueryBacklogRequest sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsQueryBacklogRequest purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户id
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsQueryBacklogRequest businessType(String businessType) {
    this.businessType = businessType;
    return this;
  }

   /**
   * 业务类型 (\"1001\",\"1002\", \"2001\",\"2002\");
   * @return businessType
  **/
  @ApiModelProperty(value = "业务类型 (\"1001\",\"1002\", \"2001\",\"2002\");")
  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryBacklogRequest queryBacklogRequest = (MsQueryBacklogRequest) o;
    return Objects.equals(this.pageSize, queryBacklogRequest.pageSize) &&
        Objects.equals(this.pageIndex, queryBacklogRequest.pageIndex) &&
        Objects.equals(this.sellerTenantId, queryBacklogRequest.sellerTenantId) &&
        Objects.equals(this.purchaserTenantId, queryBacklogRequest.purchaserTenantId) &&
        Objects.equals(this.businessType, queryBacklogRequest.businessType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageSize, pageIndex, sellerTenantId, purchaserTenantId, businessType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryBacklogRequest {\n");
    
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
