package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 结算单付款金额查询参数
 */
@ApiModel(description = "结算单付款金额查询参数")

@JsonInclude(NON_NULL)
public class MsQueryBillPaymentModel {
  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("year")
  private Integer year = null;

  @JsonProperty("uploadTime")
  private List<Long> uploadTime = new ArrayList<Long>();

  @JsonIgnore
  public MsQueryBillPaymentModel sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

   /**
   * 销方租户id
   * @return sellerTenantId
  **/
  @ApiModelProperty(value = "销方租户id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public MsQueryBillPaymentModel sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsQueryBillPaymentModel purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

   /**
   * 购方租户id
   * @return purchaserTenantId
  **/
  @ApiModelProperty(value = "购方租户id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public MsQueryBillPaymentModel purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsQueryBillPaymentModel year(Integer year) {
    this.year = year;
    return this;
  }

   /**
   * 年份
   * @return year
  **/
  @ApiModelProperty(value = "年份")
  public Integer getYear() {
    return year;
  }

  public void setYear(Integer year) {
    this.year = year;
  }

  @JsonIgnore
  public MsQueryBillPaymentModel uploadTime(List<Long> uploadTime) {
    this.uploadTime = uploadTime;
    return this;
  }

  public MsQueryBillPaymentModel addUploadTimeItem(Long uploadTimeItem) {
    this.uploadTime.add(uploadTimeItem);
    return this;
  }

   /**
   * 上传单据时间段
   * @return uploadTime
  **/
  @ApiModelProperty(value = "上传单据时间段")
  public List<Long> getUploadTime() {
    return uploadTime;
  }

  public void setUploadTime(List<Long> uploadTime) {
    this.uploadTime = uploadTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsQueryBillPaymentModel queryBillPaymentModel = (MsQueryBillPaymentModel) o;
    return Objects.equals(this.sellerTenantId, queryBillPaymentModel.sellerTenantId) &&
        Objects.equals(this.sellerTaxNo, queryBillPaymentModel.sellerTaxNo) &&
        Objects.equals(this.purchaserTenantId, queryBillPaymentModel.purchaserTenantId) &&
        Objects.equals(this.purchaserTaxNo, queryBillPaymentModel.purchaserTaxNo) &&
        Objects.equals(this.year, queryBillPaymentModel.year) &&
        Objects.equals(this.uploadTime, queryBillPaymentModel.uploadTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerTenantId, sellerTaxNo, purchaserTenantId, purchaserTaxNo, year, uploadTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsQueryBillPaymentModel {\n");
    
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    year: ").append(toIndentedString(year)).append("\n");
    sb.append("    uploadTime: ").append(toIndentedString(uploadTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
