package com.xforceplus.ant.system.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取用户TOKEN请求对象
 */
@ApiModel(description = "获取用户TOKEN请求对象")

@JsonInclude(NON_NULL)
public class MsSsoGetUserAccessTokenRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("userAccount")
  private String userAccount = null;

  @JsonIgnore
  public MsSsoGetUserAccessTokenRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户ID
   * @return userId
  **/
  @ApiModelProperty(value = "用户ID")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsSsoGetUserAccessTokenRequest userAccount(String userAccount) {
    this.userAccount = userAccount;
    return this;
  }

   /**
   * 用户账户
   * @return userAccount
  **/
  @ApiModelProperty(value = "用户账户")
  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSsoGetUserAccessTokenRequest ssoGetUserAccessTokenRequest = (MsSsoGetUserAccessTokenRequest) o;
    return Objects.equals(this.userId, ssoGetUserAccessTokenRequest.userId) &&
        Objects.equals(this.userAccount, ssoGetUserAccessTokenRequest.userAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, userAccount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSsoGetUserAccessTokenRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userAccount: ").append(toIndentedString(userAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
